

<?php
use Illuminate\Support\Facades\Storage;
?>

<?php $__env->startSection('title', 'Conversa - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<style>
    body {
        background-color: #f8f9fa !important;
    }
    .card {
        background-color: #fff !important;
        border: 1px solid #dee2e6 !important;
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
    }
    .card-body {
        background-color: #f8f9fa !important;
    }
    .card-footer {
        background-color: #fff !important;
        border-top: 1px solid #dee2e6 !important;
    }
    .form-control {
        background-color: #fff !important;
        color: #212529 !important;
        border: 1px solid #dee2e6 !important;
    }
    .form-control:focus {
        background-color: #fff !important;
        color: #212529 !important;
        border-color: #0d6efd !important;
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25) !important;
    }
    textarea.form-control {
        min-height: 60px;
        background-color: #fff !important;
        color: #212529 !important;
    }
    .bg-light {
        background-color: #f8f9fa !important;
    }
    .bg-primary {
        background-color: #0d6efd !important;
    }
</style>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h4 class="mb-0">
                    <i class="bi bi-chat-dots text-primary me-2"></i>
                    Conversa com <?php echo e($user->name); ?>

                </h4>
            </div>
            <div>
                <?php if(!auth()->user()->isSuperadmin()): ?>
                    <button type="button" class="btn btn-sm btn-danger me-2" onclick="deleteConversation()" title="Deletar conversa">
                        <i class="bi bi-trash"></i> Deletar Conversa
                    </button>
                <?php endif; ?>
                <a href="<?php echo e(route('chat.index')); ?>" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body" style="height: 500px; overflow-y: auto; background-color: #f8f9fa;" id="messagesContainer">
        <?php if($messages->count() > 0): ?>
            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="mb-3 <?php echo e($message->sender_id === auth()->id() ? 'text-end' : 'text-start'); ?>" data-message-id="<?php echo e($message->id); ?>">
                    <div class="d-inline-block p-3 rounded <?php echo e($message->sender_id === auth()->id() ? 'bg-primary text-white' : 'bg-white border'); ?>" style="max-width: 70%; box-shadow: 0 1px 3px rgba(0,0,0,0.1); position: relative;">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <small class="<?php echo e($message->sender_id === auth()->id() ? 'text-white-50' : 'text-muted'); ?>">
                                <strong><?php echo e($message->sender->name); ?></strong>
                                <span class="ms-2"><?php echo e($message->created_at->format('d/m/Y H:i')); ?></span>
                            </small>
                            <?php if($message->sender_id === auth()->id() || $message->receiver_id === auth()->id()): ?>
                                <button type="button" class="btn btn-sm p-0 ms-2 <?php echo e($message->sender_id === auth()->id() ? 'text-white-50' : 'text-muted'); ?>" onclick="deleteMessage(<?php echo e($message->id); ?>)" title="Deletar mensagem" style="border: none; background: none;">
                                    <i class="bi bi-trash"></i>
                                </button>
                            <?php endif; ?>
                        </div>
                        <?php if($message->file_path): ?>
                            <div class="mb-2">
                                <a href="<?php echo e(Storage::url($message->file_path)); ?>" target="_blank" class="btn btn-sm <?php echo e($message->sender_id === auth()->id() ? 'btn-light' : 'btn-primary'); ?>">
                                    <i class="bi bi-file-earmark"></i> <?php echo e($message->file_name); ?>

                                    <small class="ms-1">(<?php echo e(number_format($message->file_size / 1024, 2)); ?> KB)</small>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if($message->message): ?>
                            <div style="word-wrap: break-word;"><?php echo e($message->message); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="text-center text-muted py-5">
                <i class="bi bi-chat-dots display-4 d-block mb-3"></i>
                <p>Nenhuma mensagem ainda. Inicie a conversa!</p>
            </div>
        <?php endif; ?>
    </div>
    <?php if(!auth()->user()->isSuperadmin()): ?>
        <div class="card-footer bg-white border-top p-2">
            <form id="messageForm" method="POST" action="<?php echo e(route('chat.store')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="receiver_id" value="<?php echo e($user->id); ?>">
                <div class="mb-2">
                    <input type="file" name="file" id="fileInput" class="form-control form-control-sm" accept=".pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.txt,.jpg,.jpeg,.png,.gif,.zip,.rar" style="display: none;">
                    <div id="filePreview" class="small text-muted mb-1" style="display: none;"></div>
                </div>
                <div class="input-group input-group-sm">
                    <button type="button" class="btn btn-outline-secondary" onclick="document.getElementById('fileInput').click()" title="Anexar arquivo">
                        <i class="bi bi-paperclip"></i>
                    </button>
                    <textarea name="message" 
                              id="messageInput" 
                              class="form-control" 
                              rows="1" 
                              placeholder="Mensagem..." 
                              autofocus
                              style="resize: none; background-color: #fff; border: 1px solid #dee2e6; min-height: 38px;"></textarea>
                    <button type="submit" class="btn btn-primary" id="sendButton">
                        <i class="bi bi-send"></i>
                    </button>
                </div>
            </form>
        </div>
    <?php else: ?>
        <div class="card-footer bg-light border-top p-2">
            <small class="text-muted">
                <i class="bi bi-info-circle me-1"></i>Modo visualização
            </small>
        </div>
    <?php endif; ?>
</div>

<script>
<?php if(!auth()->user()->isSuperadmin()): ?>
const currentUserId = <?php echo e(auth()->id()); ?>;
const receiverId = <?php echo e($user->id); ?>;
let typingTimeout;
let isTyping = false;
let checkTypingInterval;
let checkMessagesInterval;
let lastMessageId = <?php echo e($messages->count() > 0 ? $messages->last()->id : 0); ?>;

document.getElementById('messageForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const messageInput = this.querySelector('textarea[name="message"]') || this.querySelector('input[name="message"]');
    const fileInput = document.getElementById('fileInput');
    const message = messageInput ? messageInput.value.trim() : '';
    const hasFile = fileInput && fileInput.files[0];
    
    // Parar indicador de digitação
    stopTyping();
    
    // Validar que há mensagem ou arquivo
    if (!message && !hasFile) {
        alert('É necessário enviar uma mensagem ou um arquivo.');
        return;
    }
    
    const button = this.querySelector('button[type="submit"]');
    const originalButtonText = button.innerHTML;
    button.disabled = true;
    button.innerHTML = '<span class="spinner-border spinner-border-sm"></span>';
    
    fetch(this.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(async response => {
        // Verificar se a resposta é OK
        if (!response.ok) {
            let errorMessage = 'Erro ao enviar mensagem';
            try {
                const errorData = await response.json();
                errorMessage = errorData.error || errorMessage;
            } catch (e) {
                errorMessage = 'Erro ao enviar mensagem (Status: ' + response.status + ')';
            }
            throw new Error(errorMessage);
        }
        
        const contentType = response.headers.get('content-type');
        if (!contentType || !contentType.includes('application/json')) {
            throw new Error('Resposta do servidor não é JSON válido');
        }
        
        return response.json();
    })
    .then(data => {
        button.disabled = false;
        button.innerHTML = originalButtonText;
        
        if (data && data.success && data.message) {
            // Garantir que sender existe
            if (!data.message.sender) {
                console.error('Resposta sem sender:', data);
                // Tentar buscar a mensagem novamente
                setTimeout(() => checkNewMessages(), 1000);
                return;
            }
            
            // Adicionar a mensagem dinamicamente
            try {
                addMessageToChat(data.message);
                // Atualizar último ID de mensagem
                lastMessageId = Math.max(lastMessageId, data.message.id);
                // Limpar o campo
                messageInput.value = '';
                messageInput.style.height = 'auto';
                // Atualizar contador de mensagens não lidas
                updateUnreadCount();
                // Focar novamente
                messageInput.focus();
            } catch (error) {
                console.error('Erro ao adicionar mensagem:', error);
                // Tentar buscar a mensagem novamente
                setTimeout(() => checkNewMessages(), 1000);
            }
        } else {
            console.error('Resposta inesperada:', data);
            // Mesmo com resposta inesperada, verificar se a mensagem foi enviada
            const messageText = messageInput.value.trim();
            if (messageText) {
                // Limpar campo e verificar novas mensagens
                messageInput.value = '';
                setTimeout(() => {
                    checkNewMessages();
                    // Se não apareceu nova mensagem, restaurar o texto
                    setTimeout(() => {
                        const lastMessage = document.querySelector('[data-message-id]');
                        if (!lastMessage || !lastMessage.textContent.includes(messageText)) {
                            messageInput.value = messageText;
                            alert('Erro ao enviar mensagem. Tente novamente.');
                        } else {
                            // Mensagem foi enviada, atualizar contador
                            updateUnreadCount();
                        }
                    }, 1500);
                }, 500);
            } else {
                alert('Erro ao enviar mensagem: ' + (data?.error || 'Resposta inválida do servidor'));
            }
            messageInput.focus();
        }
    })
    .catch(error => {
        console.error('Erro ao enviar mensagem:', error);
        button.disabled = false;
        button.innerHTML = originalButtonText;
        
        // Verificar se a mensagem foi enviada mesmo assim
        const messageText = messageInput.value.trim();
        if (messageText) {
            // Limpar campo e verificar novas mensagens
            messageInput.value = '';
            setTimeout(() => {
                checkNewMessages();
                // Se não apareceu nova mensagem, restaurar o texto
                setTimeout(() => {
                    const messages = document.querySelectorAll('[data-message-id]');
                    let messageFound = false;
                    messages.forEach(msg => {
                        if (msg.textContent.includes(messageText)) {
                            messageFound = true;
                        }
                    });
                    
                    if (!messageFound) {
                        messageInput.value = messageText;
                        alert('Erro ao enviar mensagem: ' + error.message);
                    } else {
                        // Mensagem foi enviada, atualizar contador
                        updateUnreadCount();
                    }
                }, 1500);
            }, 500);
        } else {
            alert('Erro ao enviar mensagem: ' + error.message);
        }
        
        messageInput.focus();
    });
});

// Função para escapar HTML (segurança)
function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// Função para adicionar mensagem ao chat
function addMessageToChat(messageData) {
    const container = document.getElementById('messagesContainer');
    if (!container) {
        console.error('Container de mensagens não encontrado');
        return;
    }
    
    // Validar dados da mensagem (mensagem ou arquivo deve existir)
    if (!messageData || !messageData.id || !messageData.sender || (!messageData.message && !messageData.file_path)) {
        console.error('Dados da mensagem inválidos:', messageData);
        return;
    }
    
    // Verificar se a mensagem já existe (evitar duplicatas)
    const existingMessage = document.querySelector(`[data-message-id="${messageData.id}"]`);
    if (existingMessage) {
        return; // Mensagem já existe
    }
    
    // Remover mensagem de "nenhuma mensagem"
    const emptyMessage = container.querySelector('.text-center');
    if (emptyMessage) {
        emptyMessage.remove();
    }
    
    // Criar elemento da mensagem
    const messageDiv = document.createElement('div');
    messageDiv.className = 'mb-3 ' + (messageData.sender_id === currentUserId ? 'text-end' : 'text-start');
    messageDiv.setAttribute('data-message-id', messageData.id);
    
    const isOwnMessage = messageData.sender_id === currentUserId;
    const bgClass = isOwnMessage ? 'bg-primary text-white' : 'bg-white border';
    const textClass = isOwnMessage ? 'text-white-50' : 'text-muted';
    
    // Formatar data
    let formattedDate = '';
    try {
        const date = new Date(messageData.created_at);
        if (!isNaN(date.getTime())) {
            const day = String(date.getDate()).padStart(2, '0');
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const year = date.getFullYear();
            const hours = String(date.getHours()).padStart(2, '0');
            const minutes = String(date.getMinutes()).padStart(2, '0');
            formattedDate = `${day}/${month}/${year} ${hours}:${minutes}`;
        }
    } catch (e) {
        formattedDate = 'Agora';
    }
    
    const senderName = messageData.sender && messageData.sender.name ? messageData.sender.name : 'Usuário';
    
    // Construir HTML do arquivo se existir
    let fileHtml = '';
    if (messageData.file_path && messageData.file_name) {
        const fileSize = messageData.file_size ? `(${(messageData.file_size / 1024).toFixed(2)} KB)` : '';
        const fileUrl = '<?php echo e(url("/storage/")); ?>/' + messageData.file_path;
        const fileBtnClass = isOwnMessage ? 'btn-light' : 'btn-primary';
        fileHtml = `
            <div class="mb-2">
                <a href="${fileUrl}" target="_blank" class="btn btn-sm ${fileBtnClass}">
                    <i class="bi bi-file-earmark"></i> ${escapeHtml(messageData.file_name)}
                    <small class="ms-1">${fileSize}</small>
                </a>
            </div>
        `;
    }
    
    // Botão de deletar (apenas para mensagens próprias ou recebidas)
    const deleteButton = `
        <button type="button" class="btn btn-sm p-0 ms-2 ${textClass}" onclick="deleteMessage(${messageData.id})" title="Deletar mensagem" style="border: none; background: none;">
            <i class="bi bi-trash"></i>
        </button>
    `;
    
    messageDiv.innerHTML = `
        <div class="d-inline-block p-3 rounded ${bgClass}" style="max-width: 70%; box-shadow: 0 1px 3px rgba(0,0,0,0.1); position: relative;">
            <div class="d-flex justify-content-between align-items-start mb-2">
                <small class="${textClass}">
                    <strong>${escapeHtml(senderName)}</strong>
                    <span class="ms-2">${formattedDate}</span>
                </small>
                ${deleteButton}
            </div>
            ${fileHtml}
            ${messageData.message ? `<div style="word-wrap: break-word;">${escapeHtml(messageData.message)}</div>` : ''}
        </div>
    `;
    
    container.appendChild(messageDiv);
    
    // Scroll para o final
    container.scrollTop = container.scrollHeight;
}

// Indicador de digitação (com debounce)
let typingDebounceTimeout;
function startTyping() {
    clearTimeout(typingDebounceTimeout);
    
    // Debounce de 500ms antes de enviar
    typingDebounceTimeout = setTimeout(() => {
        if (!isTyping) {
            isTyping = true;
            fetch('<?php echo e(route("chat.typing")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({
                    receiver_id: receiverId,
                    is_typing: true
                })
            }).catch(() => {}); // Silenciar erros
        }
    }, 500);
    
    clearTimeout(typingTimeout);
    typingTimeout = setTimeout(stopTyping, 2000); // Aumentado para 2 segundos
}

function stopTyping() {
    if (isTyping) {
        isTyping = false;
        fetch('<?php echo e(route("chat.typing")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                receiver_id: receiverId,
                is_typing: false
            })
        });
    }
    clearTimeout(typingTimeout);
}

// Verificar se o outro usuário está digitando
function checkTyping() {
    fetch('<?php echo e(route("chat.typing.check")); ?>?sender_id=' + receiverId, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        const typingIndicator = document.getElementById('typingIndicator');
        if (data.is_typing) {
            if (!typingIndicator) {
                const container = document.getElementById('messagesContainer');
                const indicator = document.createElement('div');
                indicator.id = 'typingIndicator';
                indicator.className = 'mb-2 text-start';
                const userName = '<?php echo e(addslashes($user->name)); ?>';
                indicator.innerHTML = `
                    <div class="d-inline-block p-2 rounded bg-light border">
                        <small class="text-muted">
                            <span class="typing-dots">
                                <span>.</span><span>.</span><span>.</span>
                            </span>
                            ${userName} está digitando...
                        </small>
                    </div>
                `;
                container.appendChild(indicator);
                container.scrollTop = container.scrollHeight;
                
                // Animação dos pontos
                const dots = indicator.querySelectorAll('.typing-dots span');
                let dotIndex = 0;
                const dotInterval = setInterval(() => {
                    dots.forEach((dot, i) => {
                        dot.style.opacity = i === dotIndex ? '1' : '0.3';
                    });
                    dotIndex = (dotIndex + 1) % 3;
                }, 300);
                
                // Armazenar intervalo para limpar depois
                indicator.dataset.intervalId = dotInterval;
            }
        } else {
            if (typingIndicator) {
                if (typingIndicator.dataset.intervalId) {
                    clearInterval(parseInt(typingIndicator.dataset.intervalId));
                }
                typingIndicator.remove();
            }
        }
    })
    .catch(error => console.error('Erro ao verificar digitação:', error));
}

// Auto-resize do textarea e indicador de digitação
const messageInput = document.getElementById('messageInput');
if (messageInput) {
    messageInput.addEventListener('input', function() {
        this.style.height = 'auto';
        this.style.height = (this.scrollHeight) + 'px';
        
        // Indicador de digitação
        if (this.value.trim().length > 0) {
            startTyping();
        } else {
            stopTyping();
        }
    });
    
    messageInput.addEventListener('blur', function() {
        stopTyping();
    });
}

// Função para buscar novas mensagens (otimizada)
function checkNewMessages() {
    // Não verificar se a página não está visível
    if (document.hidden) return;
    
    fetch('<?php echo e(route("chat.new-messages")); ?>?user_id=' + receiverId + '&last_message_id=' + lastMessageId, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        cache: 'no-cache'
    })
    .then(response => {
        if (!response.ok) return null;
        return response.json();
    })
    .then(data => {
        if (data && data.messages && data.messages.length > 0) {
            let hasNewReceivedMessages = false;
            data.messages.forEach(message => {
                // Verificar se a mensagem já não existe (evitar duplicatas)
                const existingMessage = document.querySelector(`[data-message-id="${message.id}"]`);
                if (!existingMessage) {
                    addMessageToChat(message);
                    lastMessageId = Math.max(lastMessageId, message.id);
                    // Verificar se é mensagem recebida (não enviada por mim)
                    if (message.sender_id !== currentUserId) {
                        hasNewReceivedMessages = true;
                    }
                }
            });
            // Marcar como lidas se houver novas mensagens recebidas
            if (hasNewReceivedMessages) {
                markMessagesAsRead();
            }
        }
    })
    .catch(error => {
        // Silenciar erros de rede para não poluir console
        if (error.name !== 'TypeError') {
            console.error('Erro ao verificar novas mensagens:', error);
        }
    });
}

// Função para atualizar contador de mensagens não lidas (otimizada com cache)
let lastUnreadCount = null;
let lastUnreadCountTime = 0;
function updateUnreadCount() {
    // Cache de 2 segundos para evitar requisições excessivas
    const now = Date.now();
    if (lastUnreadCount !== null && (now - lastUnreadCountTime) < 2000) {
        return;
    }
    
    fetch('<?php echo e(route("chat.unread.count")); ?>', {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        cache: 'no-cache'
    })
    .then(response => {
        if (!response.ok) return null;
        return response.json();
    })
    .then(data => {
        if (data) {
            lastUnreadCount = data.count;
            lastUnreadCountTime = Date.now();
            
            const badge = document.getElementById('chatBadge');
            if (badge) {
                if (data.count > 0) {
                    badge.textContent = data.count > 99 ? '99+' : data.count;
                    badge.style.display = 'block';
                } else {
                    badge.style.display = 'none';
                }
            }
        }
    })
    .catch(error => {
        // Silenciar erros de rede
        if (error.name !== 'TypeError') {
            console.error('Erro ao atualizar contador:', error);
        }
    });
}

// Pausar verificações quando a página não está visível
document.addEventListener('visibilitychange', function() {
    if (document.hidden) {
        // Pausar intervalos
        if (checkTypingInterval) clearInterval(checkTypingInterval);
        if (checkMessagesInterval) clearInterval(checkMessagesInterval);
    } else {
        // Retomar intervalos
        checkTypingInterval = setInterval(checkTyping, 3000);
        checkMessagesInterval = setInterval(checkNewMessagesThrottled, 5000);
        // Verificar imediatamente ao voltar
        checkNewMessages();
    }
});

// Verificar digitação a cada 3 segundos (reduzido para melhor performance)
checkTypingInterval = setInterval(checkTyping, 3000);

// Verificar novas mensagens a cada 5 segundos (reduzido para melhor performance)
let isCheckingMessages = false;
function checkNewMessagesThrottled() {
    if (isCheckingMessages || document.hidden) return;
    isCheckingMessages = true;
    checkNewMessages();
    setTimeout(() => {
        isCheckingMessages = false;
    }, 1000);
}
checkMessagesInterval = setInterval(checkNewMessagesThrottled, 5000);

// Limpar ao sair da página
window.addEventListener('beforeunload', function() {
    stopTyping();
    if (checkTypingInterval) {
        clearInterval(checkTypingInterval);
    }
    if (checkMessagesInterval) {
        clearInterval(checkMessagesInterval);
    }
});

// Marcar mensagens como lidas ao carregar a página
function markMessagesAsRead() {
    fetch('<?php echo e(route("chat.mark-as-read")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            user_id: receiverId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Atualizar contador após marcar como lidas
            updateUnreadCount();
        }
    })
    .catch(error => {
        // Silenciar erros
    });
}

// Scroll para o final ao carregar
document.addEventListener('DOMContentLoaded', function() {
    const container = document.getElementById('messagesContainer');
    if (container) {
        container.scrollTop = container.scrollHeight;
    }
    
    const messageInput = document.getElementById('messageInput');
    if (messageInput) {
        messageInput.focus();
    }
    
    // Marcar mensagens como lidas ao abrir a conversa
    markMessagesAsRead();
    
    // Marcar como lidas também quando novas mensagens são recebidas
    const originalCheckNewMessages = checkNewMessages;
    checkNewMessages = function() {
        originalCheckNewMessages();
        // Atualizar contador após verificar novas mensagens
        updateUnreadCount();
    };
});

// Função para deletar mensagem usando XMLHttpRequest (mais compatível)
function deleteMessage(messageId) {
    if (!confirm('Tem certeza que deseja deletar esta mensagem?')) {
        return;
    }
    
    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '<?php echo e(csrf_token()); ?>';
    
    // Construir URL usando route helper do Laravel
    const url = '<?php echo e(route("chat.destroy.post", ":id")); ?>'.replace(':id', messageId);
    
    console.log('Deletando mensagem:', messageId);
    console.log('URL:', url);
    console.log('CSRF Token:', csrfToken ? 'Presente' : 'Ausente');
    
    // Verificar se a URL é válida
    if (!url || url.includes('undefined') || url.includes('null')) {
        alert('Erro: URL inválida. Por favor, recarregue a página e tente novamente.');
        console.error('URL inválida:', url);
        return;
    }
    
    // Usar XMLHttpRequest (mais compatível que fetch)
    const xhr = new XMLHttpRequest();
    
    xhr.onreadystatechange = function() {
        console.log('XHR readyState:', xhr.readyState, 'Status:', xhr.status);
        
        if (xhr.readyState === XMLHttpRequest.DONE) {
            if (xhr.status === 200) {
                try {
                    const data = JSON.parse(xhr.responseText);
                    if (data && data.success) {
                        // Remover mensagem do DOM
                        const messageElement = document.querySelector(`[data-message-id="${messageId}"]`);
                        if (messageElement) {
                            messageElement.remove();
                        }
                        // Atualizar contador
                        if (typeof updateUnreadCount === 'function') {
                            updateUnreadCount();
                        }
                    } else {
                        alert('Erro ao deletar mensagem: ' + (data?.error || 'Erro desconhecido'));
                    }
                } catch (e) {
                    console.error('Erro ao parsear resposta:', e);
                    // Mesmo assim, tentar remover a mensagem se a resposta foi 200
                    const messageElement = document.querySelector(`[data-message-id="${messageId}"]`);
                    if (messageElement) {
                        messageElement.remove();
                    }
                    if (typeof updateUnreadCount === 'function') {
                        updateUnreadCount();
                    }
                }
            } else if (xhr.status === 0) {
                // Status 0 geralmente indica que a requisição não foi completada
                console.error('Status 0 - Requisição não completada');
                console.error('Response:', xhr.responseText);
                alert('Erro de conexão. A requisição não foi completada. Verifique sua conexão e tente novamente.');
            } else {
                let errorMessage = 'Erro ao deletar mensagem';
                try {
                    const errorData = JSON.parse(xhr.responseText);
                    errorMessage = errorData.error || errorMessage;
                } catch (e) {
                    errorMessage = 'Erro ao deletar mensagem (Status: ' + xhr.status + ')';
                    console.error('Resposta do servidor:', xhr.responseText);
                }
                alert(errorMessage);
            }
        }
    };
    
    xhr.onerror = function() {
        console.error('Erro de rede ao deletar mensagem');
        console.error('Status:', xhr.status);
        console.error('Status Text:', xhr.statusText);
        alert('Erro de conexão. Verifique sua conexão com a internet e tente novamente.');
    };
    
    xhr.ontimeout = function() {
        console.error('Timeout ao deletar mensagem');
        alert('Tempo de espera esgotado. Tente novamente.');
    };
    
    // Configurar timeout de 10 segundos
    xhr.timeout = 10000;
    
    // Abrir conexão
    try {
        xhr.open('POST', url, true);
        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
        xhr.setRequestHeader('Accept', 'application/json');
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        
        // Enviar requisição com CSRF token
        xhr.send('_token=' + encodeURIComponent(csrfToken));
    } catch (e) {
        console.error('Erro ao abrir conexão:', e);
        alert('Erro ao iniciar requisição. Por favor, recarregue a página e tente novamente.');
    }
}

// Função para deletar conversa
function deleteConversation() {
    if (!confirm('Tem certeza que deseja deletar toda a conversa? Esta ação não pode ser desfeita.')) {
        return;
    }
    
    fetch('<?php echo e(route("chat.delete-conversation")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            user_id: receiverId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Redirecionar para lista de conversas
            window.location.href = '<?php echo e(route("chat.index")); ?>';
        } else {
            alert('Erro ao deletar conversa: ' + (data.error || 'Erro desconhecido'));
        }
    })
    .catch(error => {
        console.error('Erro ao deletar conversa:', error);
        alert('Erro ao deletar conversa. Tente novamente.');
    });
}

// Preview de arquivo selecionado
const fileInput = document.getElementById('fileInput');
if (fileInput) {
    fileInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        const preview = document.getElementById('filePreview');
        
        if (file) {
            const fileSize = (file.size / 1024).toFixed(2);
            preview.innerHTML = `<i class="bi bi-file-earmark"></i> ${file.name} (${fileSize} KB)`;
            preview.style.display = 'block';
        } else {
            preview.style.display = 'none';
        }
    });
}
<?php endif; ?>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/chat/show.blade.php ENDPATH**/ ?>