

<?php $__env->startSection('title', 'Mensagens - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .modal-backdrop {
        display: none !important;
    }
    .modal.show .modal-backdrop {
        display: none !important;
    }
    .modal-content {
        background-color: #ffffff !important;
        border: 2px solid #0d6efd !important;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
    }
    .modal-body {
        background-color: #ffffff !important;
        color: #212529 !important;
    }
    .modal-header {
        background-color: #0d6efd !important;
        color: #ffffff !important;
        border-bottom: 2px solid #0d6efd !important;
    }
    .form-select, .form-control {
        background-color: #ffffff !important;
        color: #212529 !important;
        border: 1px solid #ced4da !important;
    }
    .form-select:focus, .form-control:focus {
        background-color: #ffffff !important;
        color: #212529 !important;
        border-color: #0d6efd !important;
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25) !important;
    }
    .form-label {
        color: #212529 !important;
        font-weight: 600;
    }
    .list-group-item {
        background-color: #ffffff !important;
        border: 1px solid #dee2e6 !important;
    }
    .list-group-item:hover {
        background-color: #f8f9fa !important;
    }
</style>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-chat-dots text-primary me-2"></i>
                Mensagens
            </h4>
            <div>
                <?php if(auth()->user()->isAdmin()): ?>
                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalNovaMensagem">
                        <i class="bi bi-plus-circle me-1"></i> Nova Mensagem
                    </button>
                <?php elseif(auth()->user()->isAluno()): ?>
                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalNovaMensagem">
                        <i class="bi bi-plus-circle me-1"></i> Nova Mensagem
                    </button>
                <?php elseif(auth()->user()->isSuperadmin()): ?>
                    <span class="badge bg-info">
                        <i class="bi bi-eye me-1"></i> Modo Visualização
                    </span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php if($conversations->count() > 0): ?>
    <div class="list-group">
        <?php $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('chat.show', $conversation['user'])); ?>" 
               class="list-group-item list-group-item-action"
               onclick="markConversationAsRead(<?php echo e($conversation['user']->id); ?>, event)">
                <div class="d-flex w-100 justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <div class="me-3">
                            <i class="bi bi-person-circle" style="font-size: 2rem; color: #6c757d;"></i>
                        </div>
                        <div>
                            <h6 class="mb-0"><?php echo e($conversation['user']->name); ?></h6>
                            <small class="text-muted">
                                <?php echo e($conversation['last_message']->message); ?>

                            </small>
                        </div>
                    </div>
                    <div class="text-end">
                        <?php if($conversation['unread_count'] > 0): ?>
                            <span class="badge bg-primary rounded-pill"><?php echo e($conversation['unread_count']); ?></span>
                        <?php endif; ?>
                        <br>
                        <small class="text-muted"><?php echo e($conversation['last_message']->created_at->diffForHumans()); ?></small>
                    </div>
                </div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php else: ?>
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhuma conversa encontrada.
        <?php if(auth()->user()->isAdmin() || auth()->user()->isAluno()): ?>
            <br>
            <button type="button" class="btn btn-primary mt-2" data-bs-toggle="modal" data-bs-target="#modalNovaMensagem">
                <i class="bi bi-plus-circle me-1"></i> Iniciar Nova Conversa
            </button>
        <?php elseif(auth()->user()->isSuperadmin()): ?>
            <br>
            <small class="text-muted">Superadmin está no modo de visualização apenas.</small>
        <?php endif; ?>
    </div>
<?php endif; ?>

<!-- Modal para Nova Mensagem -->
<div class="modal fade" id="modalNovaMensagem" tabindex="-1" aria-labelledby="modalNovaMensagemLabel" aria-hidden="true" data-bs-backdrop="false" style="z-index: 1055;">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content" style="background-color: #fff; border: 1px solid #dee2e6; box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);">
            <div class="modal-header py-2" style="background-color: #0d6efd; color: #fff; border-bottom: 1px solid #0d6efd;">
                <h6 class="modal-title mb-0" id="modalNovaMensagemLabel">
                    <i class="bi bi-chat-dots me-1"></i>Nova Mensagem
                </h6>
                <button type="button" class="btn-close btn-close-white btn-sm" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="formNovaMensagem" method="GET" action="<?php echo e(route('chat.show', 0)); ?>">
                <div class="modal-body" style="background-color: #fff; padding: 1rem; color: #212529;">
                    <?php if(auth()->user()->isAdmin()): ?>
                        <select class="form-select form-select-sm mb-2" id="tipoDestinatario" name="tipo" required>
                            <option value="">Destinatário...</option>
                            <option value="geral">Todos</option>
                            <option value="professores">Professores</option>
                            <option value="alunos">Alunos</option>
                            <option value="especifico">Usuário</option>
                        </select>
                        <select class="form-select form-select-sm" id="usuarioEspecifico" name="user_id" style="display: none;">
                            <option value="">Selecione...</option>
                            <?php if(isset($availableUsers)): ?>
                                <?php
                                    $professores = $availableUsers->where('tipo', 'professor');
                                    $alunos = $availableUsers->where('tipo', 'aluno');
                                ?>
                                <?php if($professores->count() > 0): ?>
                                    <optgroup label="Professores">
                                        <?php $__currentLoopData = $professores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prof): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($prof->id); ?>"><?php echo e($prof->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endif; ?>
                                <?php if($alunos->count() > 0): ?>
                                    <optgroup label="Alunos">
                                        <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($aluno->id); ?>"><?php echo e($aluno->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endif; ?>
                            <?php endif; ?>
                        </select>
                    <?php elseif(auth()->user()->isAluno()): ?>
                        <select class="form-select form-select-sm mb-2" id="tipoDestinatario" name="tipo" required>
                            <option value="">Destinatário...</option>
                            <option value="direcao">Direção</option>
                            <option value="professor">Professor</option>
                        </select>
                        <select class="form-select form-select-sm" id="professorEspecifico" name="user_id" style="display: none;">
                            <option value="">Selecione...</option>
                            <?php if(isset($availableUsers)): ?>
                                <?php
                                    $professores = $availableUsers->where('tipo', 'professor');
                                    $admins = $availableUsers->where('tipo', 'admin');
                                ?>
                                <?php if($admins->count() > 0): ?>
                                    <optgroup label="Direção" data-tipo="direcao">
                                        <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($admin->id); ?>" data-tipo="direcao"><?php echo e($admin->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endif; ?>
                                <?php if($professores->count() > 0): ?>
                                    <optgroup label="Professores" data-tipo="professor">
                                        <?php $__currentLoopData = $professores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prof): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($prof->id); ?>" data-tipo="professor"><?php echo e($prof->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endif; ?>
                            <?php endif; ?>
                        </select>
                    <?php endif; ?>
                </div>
                <div class="modal-footer" style="padding: 0.5rem 1rem; border-top: 1px solid #dee2e6;">
                    <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-sm btn-primary">Continuar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('tipoDestinatario')?.addEventListener('change', function() {
    const tipo = this.value;
    const usuarioEspecifico = document.getElementById('usuarioEspecifico');
    const professorEspecifico = document.getElementById('professorEspecifico');
    
    if (usuarioEspecifico) {
        usuarioEspecifico.style.display = tipo === 'especifico' ? 'block' : 'none';
        usuarioEspecifico.required = tipo === 'especifico';
        if (tipo !== 'especifico') {
            usuarioEspecifico.value = '';
        }
    }
    
    if (professorEspecifico) {
        if (tipo === 'professor' || tipo === 'direcao') {
            professorEspecifico.style.display = 'block';
            professorEspecifico.required = true;
            
            // Filtrar opções baseado no tipo selecionado
            const options = professorEspecifico.querySelectorAll('option, optgroup');
            options.forEach(option => {
                if (option.tagName === 'OPTGROUP') {
                    // Mostrar/ocultar grupos
                    if (option.getAttribute('data-tipo') === tipo) {
                        option.style.display = '';
                    } else {
                        option.style.display = 'none';
                    }
                } else if (option.tagName === 'OPTION' && option.value !== '') {
                    // Mostrar/ocultar opções individuais
                    if (option.getAttribute('data-tipo') === tipo) {
                        option.style.display = '';
                    } else {
                        option.style.display = 'none';
                    }
                } else {
                    // Sempre mostrar a opção vazia "Selecione..."
                    option.style.display = '';
                }
            });
            
            // Limpar seleção se mudou de tipo
            const selectedOption = professorEspecifico.options[professorEspecifico.selectedIndex];
            if (selectedOption && selectedOption.getAttribute('data-tipo') !== tipo) {
                professorEspecifico.value = '';
            }
        } else {
            professorEspecifico.style.display = 'none';
            professorEspecifico.required = false;
            professorEspecifico.value = '';
            
            // Mostrar todas as opções novamente quando oculto
            const options = professorEspecifico.querySelectorAll('option, optgroup');
            options.forEach(option => {
                option.style.display = '';
            });
        }
    }
});

// Remover backdrop escuro quando modal abrir
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('modalNovaMensagem');
    if (modal) {
        modal.addEventListener('show.bs.modal', function() {
            // Remover qualquer backdrop existente
            const backdrops = document.querySelectorAll('.modal-backdrop');
            backdrops.forEach(backdrop => backdrop.remove());
            
            // Resetar formulário e mostrar todas as opções
            const tipoDestinatario = document.getElementById('tipoDestinatario');
            const professorEspecifico = document.getElementById('professorEspecifico');
            
            if (tipoDestinatario) {
                tipoDestinatario.value = '';
            }
            
            if (professorEspecifico) {
                professorEspecifico.style.display = 'none';
                professorEspecifico.value = '';
                // Mostrar todas as opções novamente
                const options = professorEspecifico.querySelectorAll('option, optgroup');
                options.forEach(option => {
                    option.style.display = '';
                });
            }
            
            // Garantir que não há backdrop
            const modalInstance = bootstrap.Modal.getInstance(modal);
            if (modalInstance) {
                modalInstance._config.backdrop = false;
            }
        });
    }
});

document.getElementById('formNovaMensagem')?.addEventListener('submit', function(e) {
    e.preventDefault();
    const tipo = document.getElementById('tipoDestinatario').value;
    
    if (!tipo) {
        alert('Por favor, selecione um destinatário.');
        return;
    }
    
    if (tipo === 'geral' || tipo === 'professores' || tipo === 'alunos' || tipo === 'escola') {
        // Redirecionar para página de criar mensagem em massa
        window.location.href = '<?php echo e(route("chat.create")); ?>?tipo=' + tipo;
    } else if (tipo === 'especifico' || tipo === 'professor' || tipo === 'direcao') {
        const userId = tipo === 'especifico' 
            ? document.getElementById('usuarioEspecifico')?.value
            : document.getElementById('professorEspecifico')?.value;
        
        if (!userId) {
            alert('Por favor, selecione um destinatário.');
            return;
        }
        
        window.location.href = '<?php echo e(route("chat.show", ":id")); ?>'.replace(':id', userId);
    }
});

// Marcar conversa como lida ao clicar
function markConversationAsRead(userId, event) {
    fetch('<?php echo e(route("chat.mark-as-read")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            user_id: userId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Atualizar contador global
            const badge = document.getElementById('chatBadge');
            if (badge) {
                const currentCount = parseInt(badge.textContent) || 0;
                const newCount = Math.max(0, currentCount - data.updated);
                if (newCount > 0) {
                    badge.textContent = newCount > 99 ? '99+' : newCount;
                    badge.style.display = 'block';
                } else {
                    badge.style.display = 'none';
                }
            }
        }
    })
    .catch(error => {
        // Silenciar erros
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/chat/index.blade.php ENDPATH**/ ?>