

<?php $__env->startSection('title', 'Pagamento - Estudante'); ?>

<?php
    $escola = \App\Models\Configuracao::get('escola', 'ESCOLA PRIMÁRIA E COMPLETA SGE');
    $logotipo = \App\Models\Configuracao::get('logotipo_escola', null);
    $logotipoUrl = $logotipo && \Illuminate\Support\Facades\Storage::disk('public')->exists($logotipo) 
        ? asset('storage/' . $logotipo) 
        : null;
    
    // Se há financeiro_id específico, mostrar apenas esse
    $dividaSelecionada = $dividas->first();
    $mostrarFormulario = $dividaSelecionada && request()->has('financeiro_id');
?>

<?php $__env->startSection('content'); ?>
<style>
    /* Estilos Mobile para Pagamento */
    @media (max-width: 768px) {
        .payment-mobile-header {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            padding: 1.5rem 1rem;
            margin: -1rem -1rem 1.5rem -1rem;
            position: relative;
        }
        
        .payment-mobile-header .back-btn {
            position: absolute;
            top: 1rem;
            left: 1rem;
            color: white;
            font-size: 1.5rem;
            text-decoration: none;
            z-index: 10;
        }
        
        .payment-mobile-header h1 {
            font-size: 1.1rem;
            font-weight: bold;
            text-transform: uppercase;
            margin: 0.5rem 0 1rem 0;
            text-align: center;
        }
        
        .payment-mobile-header .book-icon {
            text-align: center;
            font-size: 3rem;
            margin: 0.5rem 0;
        }
        
        .payment-mobile-header .school-name {
            font-size: 0.85rem;
            text-transform: uppercase;
            text-align: center;
            margin-top: 0.5rem;
        }
        
        .payment-mobile-form {
            background: white;
            padding: 1.5rem 1rem;
            margin: 0 -1rem;
        }
        
        .payment-mobile-form .form-group {
            margin-bottom: 1.5rem;
        }
        
        .payment-mobile-form label {
            font-size: 0.85rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 0.5rem;
            display: block;
        }
        
        .payment-mobile-form .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 1rem;
        }
        
        .payment-mobile-form .value-display {
            font-size: 1.5rem;
            font-weight: bold;
            color: #000;
            margin-top: 0.5rem;
        }
        
        .payment-methods {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin: 2rem 0;
        }
        
        .payment-method-card {
            border-radius: 12px;
            padding: 1.5rem 1rem;
            text-align: center;
            position: relative;
            overflow: hidden;
            min-height: 180px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        
        .payment-method-card.mpesa {
            background: linear-gradient(135deg, #ff6b35 0%, #4a90e2 100%);
        }
        
        .payment-method-card.emola {
            background: linear-gradient(135deg, #2ecc71 0%, #4a90e2 100%);
        }
        
        .payment-method-card .logo {
            font-size: 3rem;
            color: white;
            margin-bottom: 0.5rem;
        }
        
        .payment-method-card .method-name {
            color: white;
            font-weight: bold;
            font-size: 1.1rem;
            margin-bottom: 1rem;
        }
        
        .payment-method-card .pay-button {
            background: white;
            color: #4a90e2;
            border: none;
            padding: 0.75rem 1rem;
            border-radius: 8px;
            font-weight: bold;
            font-size: 0.9rem;
            width: 100%;
            cursor: pointer;
            transition: transform 0.2s;
        }
        
        .payment-method-card .pay-button:hover {
            transform: scale(1.05);
        }
        
        .payment-history-link {
            text-align: center;
            margin: 2rem 0;
        }
        
        .payment-history-link a {
            color: #4a90e2;
            text-decoration: underline;
            font-size: 0.9rem;
        }
    }
    
    /* Desktop - manter layout atual */
    @media (min-width: 769px) {
        .payment-mobile-header,
        .payment-mobile-form {
            display: none;
        }
    }
</style>

<!-- Layout Mobile -->
<div class="d-md-none">
    <div class="payment-mobile-header">
        <a href="<?php echo e(route('aluno.financeiro')); ?>" class="back-btn">
            <i class="bi bi-arrow-left"></i>
        </a>
        <h1>PAGAMENTO DE MENSALIDADES</h1>
        <div class="book-icon">📚🍎</div>
        <div class="school-name"><?php echo e($escola); ?></div>
    </div>
    
    <?php if($mostrarFormulario && $dividaSelecionada): ?>
        <?php
            $multa = isset($multasPorFinanceiro[$dividaSelecionada->id]) ? $multasPorFinanceiro[$dividaSelecionada->id]['multa'] : 0;
            $valorComMulta = isset($multasPorFinanceiro[$dividaSelecionada->id]) ? $multasPorFinanceiro[$dividaSelecionada->id]['valor_com_multa'] : $dividaSelecionada->valor;
        ?>
        
        <div class="payment-mobile-form">
            <div class="form-group">
                <label>ALUNO(A)</label>
                <input type="text" class="form-control" value="<?php echo e($aluno->user->name); ?>" readonly>
            </div>
            
            <div class="form-group">
                <label>TURMA</label>
                <div class="form-control" style="background: #f8f9fa;"><?php echo e($turma ? $turma->nome : 'N/A'); ?></div>
            </div>
            
            <div class="form-group">
                <label>VALOR:</label>
                <div class="value-display"><?php echo e(number_format($valorComMulta, 2, ',', '.')); ?> MT</div>
            </div>
            
            <div class="payment-methods">
                <form method="POST" action="<?php echo e(route('aluno.payment.store')); ?>" class="payment-method-card mpesa">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="financeiro_id" value="<?php echo e($dividaSelecionada->id); ?>">
                    <input type="hidden" name="valor" value="<?php echo e($valorComMulta); ?>">
                    <input type="hidden" name="metodo" value="MPESA">
                    
                    <div>
                        <div class="logo">📱</div>
                        <div class="method-name">M-Pesa</div>
                    </div>
                    <button type="submit" class="pay-button">PAGAR COM M-PESA</button>
                </form>
                
                <form method="POST" action="<?php echo e(route('aluno.payment.store')); ?>" class="payment-method-card emola">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="financeiro_id" value="<?php echo e($dividaSelecionada->id); ?>">
                    <input type="hidden" name="valor" value="<?php echo e($valorComMulta); ?>">
                    <input type="hidden" name="metodo" value="EMOLA">
                    
                    <div>
                        <div class="logo">💳</div>
                        <div class="method-name">e-Mola</div>
                    </div>
                    <button type="submit" class="pay-button">PAGAR COM E-MOLA</button>
                </form>
            </div>
            
            <div class="payment-history-link">
                <a href="<?php echo e(route('aluno.invoice.index')); ?>">Histórico de Pagamentos</a>
            </div>
        </div>
    <?php elseif($dividas->count() > 0): ?>
        <div class="payment-mobile-form">
            <div class="form-group">
                <label>ALUNO(A)</label>
                <input type="text" class="form-control" value="<?php echo e($aluno->user->name); ?>" readonly>
            </div>
            
            <div class="form-group">
                <label>TURMA</label>
                <div class="form-control" style="background: #f8f9fa;"><?php echo e($turma ? $turma->nome : 'N/A'); ?></div>
            </div>
            
            <div class="form-group">
                <label>SELECIONE A MENSALIDADE:</label>
                <div class="list-group">
                    <?php $__currentLoopData = $dividas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $divida): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $multa = isset($multasPorFinanceiro[$divida->id]) ? $multasPorFinanceiro[$divida->id]['multa'] : 0;
                            $valorComMulta = isset($multasPorFinanceiro[$divida->id]) ? $multasPorFinanceiro[$divida->id]['valor_com_multa'] : $divida->valor;
                        ?>
                        <a href="<?php echo e(route('aluno.payment.create', ['financeiro_id' => $divida->id])); ?>" class="list-group-item list-group-item-action">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong><?php echo e($divida->descricao); ?></strong>
                                    <br>
                                    <small class="text-muted"><?php echo e($divida->data_vencimento->format('d/m/Y')); ?></small>
                                </div>
                                <div class="text-end">
                                    <strong><?php echo e(number_format($valorComMulta, 2, ',', '.')); ?> MT</strong>
                                    <?php if($multa > 0): ?>
                                        <br><small class="text-danger">+<?php echo e(number_format($multa, 2, ',', '.')); ?> MT multa</small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="payment-mobile-form">
            <div class="alert alert-success">
                <i class="bi bi-check-circle me-2"></i>
                Não tem dívidas pendentes.
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Layout Desktop -->
<div class="d-none d-md-block">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="mb-0">
                    <i class="bi bi-credit-card text-primary me-2"></i>
                    Pagamento de Mensalidades
                </h4>
                <a href="<?php echo e(route('aluno.financeiro')); ?>" class="btn btn-secondary btn-sm">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>
    </div>

<?php if($dividas->count() > 0): ?>
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Dívidas Pendentes</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Descrição</th>
                            <th>Valor Base</th>
                            <th>Multa</th>
                            <th>Total</th>
                            <th>Data Vencimento</th>
                            <th>Status</th>
                            <th>Acções</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $dividas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $divida): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $multa = isset($multasPorFinanceiro[$divida->id]) ? $multasPorFinanceiro[$divida->id]['multa'] : 0;
                                $valorComMulta = isset($multasPorFinanceiro[$divida->id]) ? $multasPorFinanceiro[$divida->id]['valor_com_multa'] : $divida->valor;
                                $diasAtraso = isset($multasPorFinanceiro[$divida->id]) ? $multasPorFinanceiro[$divida->id]['dias_atraso'] : 0;
                            ?>
                            <tr>
                                <td><?php echo e($divida->descricao); ?></td>
                                <td><?php echo e(number_format($divida->valor, 2, ',', '.')); ?> MT</td>
                                <td class="<?php echo e($multa > 0 ? 'text-danger fw-bold' : ''); ?>">
                                    <?php if($multa > 0): ?>
                                        +<?php echo e(number_format($multa, 2, ',', '.')); ?> MT
                                        <small class="d-block text-muted">(<?php echo e($diasAtraso); ?> dias)</small>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="fw-bold"><?php echo e(number_format($valorComMulta, 2, ',', '.')); ?> MT</td>
                                <td><?php echo e($divida->data_vencimento->format('d/m/Y')); ?></td>
                                <td>
                                    <?php
                                        $isFutura = $divida->data_vencimento > now();
                                    ?>
                                    <?php if($divida->status === 'VENCIDO'): ?>
                                        <span class="badge bg-danger">Vencido</span>
                                    <?php elseif($isFutura): ?>
                                        <span class="badge bg-info">Futura (Adiantado)</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning">Pendente</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <form method="POST" action="<?php echo e(route('aluno.payment.store')); ?>" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="financeiro_id" value="<?php echo e($divida->id); ?>">
                                        <input type="hidden" name="valor" value="<?php echo e($valorComMulta); ?>">
                                        
                                        <div class="btn-group" role="group">
                                            <button type="submit" name="metodo" value="MPESA" class="btn btn-success btn-sm">
                                                <i class="bi bi-phone"></i> M-Pesa
                                            </button>
                                            <button type="submit" name="metodo" value="EMOLA" class="btn btn-primary btn-sm">
                                                <i class="bi bi-wallet2"></i> Emola
                                            </button>
                                        </div>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr class="table-info">
                            <th>Total</th>
                            <th><?php echo e(number_format($dividas->sum('valor'), 2, ',', '.')); ?> MT</th>
                            <th class="text-danger"><?php echo e(number_format($totalMultas ?? 0, 2, ',', '.')); ?> MT</th>
                            <th class="fw-bold"><?php echo e(number_format($totalDivida, 2, ',', '.')); ?> MT</th>
                            <th colspan="3"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="alert alert-success">
        <i class="bi bi-check-circle me-2"></i>
        Não tem dívidas pendentes.
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Facturas</h5>
    </div>
    <div class="card-body">
        <a href="<?php echo e(route('aluno.invoice.index')); ?>" class="btn btn-outline-primary">
            <i class="bi bi-receipt me-1"></i> Ver Minhas Facturas
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/aluno/payment/create.blade.php ENDPATH**/ ?>