

<?php $__env->startSection('title', 'Detalhes da Turma - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;"><?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?></h5>
                <small class="text-muted"><?php echo e($turma->anoLetivo->ano ?? 'N/A'); ?> | Capacidade: <?php echo e($turma->capacidade_maxima ?? 'Ilimitada'); ?> | 
                    <?php if($turma->ativa): ?>
                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activa</span>
                    <?php else: ?>
                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #e2e3e5; color: #383d41; border-radius: 3px;">Inactiva</span>
                    <?php endif; ?>
                </small>
            </div>
            <div>
                <a href="<?php echo e(route('admin.turmas.edit', $turma)); ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-pencil"></i> Editar
                </a>
                <a href="<?php echo e(route('admin.turmas.index')); ?>" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Alunos -->
            <div class="col-md-6 mb-3">
                <div class="d-flex justify-content-between align-items-center mb-1">
                    <small class="text-muted" style="font-weight: 600;">Alunos (<?php echo e($alunos->count()); ?>)</small>
                    <a href="<?php echo e(route('admin.turmas.alocar-alunos', $turma)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d4edda; color: #155724; border: none;">
                        <i class="bi bi-plus-circle"></i> Alocar
                    </a>
                </div>
                <?php if($alunos->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                            <thead style="background-color: #f8f9fa;">
                                <tr>
                                    <th style="padding: 6px;">Código</th>
                                    <th style="padding: 6px;">Nome</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="padding: 5px;"><?php echo e($aluno->codigo_estudante); ?></td>
                                        <td style="padding: 5px;"><?php echo e($aluno->user->name); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 10px;">
                        Nenhum aluno alocado
                    </p>
                <?php endif; ?>
            </div>

            <!-- Disciplinas e Professores -->
            <div class="col-md-12 mb-3">
                <div class="d-flex justify-content-between align-items-center mb-1">
                    <small class="text-muted" style="font-weight: 600;">Disciplinas e Professores</small>
                    <a href="<?php echo e(route('admin.turmas.atribuir-disciplinas', $turma)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d1ecf1; color: #0c5460; border: none;">
                        <i class="bi bi-plus-circle"></i> Gerenciar
                    </a>
                </div>
                <?php
                    $anoLetivo = \App\Models\AnoLetivo::getAnoLetivoAtual();
                    $disciplinasTurma = $turma->disciplinasAtribuidas()->wherePivot('ano_letivo_id', $anoLetivo?->id)->get();
                ?>
                <?php if($disciplinasTurma->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                            <thead style="background-color: #f8f9fa;">
                                <tr>
                                    <th style="padding: 6px;">Disciplina</th>
                                    <th style="padding: 6px;">Professor</th>
                                    <th style="padding: 6px;">Carga Horária</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $disciplinasTurma; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $professorAlocado = \Illuminate\Support\Facades\DB::table('turma_disciplina_professor')
                                            ->where('turma_id', $turma->id)
                                            ->where('disciplina_id', $disciplina->id)
                                            ->where('ano_letivo_id', $anoLetivo?->id)
                                            ->join('professores', 'turma_disciplina_professor.professor_id', '=', 'professores.id')
                                            ->whereNull('professores.deleted_at')
                                            ->join('users', 'professores.user_id', '=', 'users.id')
                                            ->whereNull('users.deleted_at')
                                            ->select('users.name as professor_nome')
                                            ->first();
                                        
                                        $cargaMin = $disciplina->pivot->carga_horaria_semanal ?? $disciplina->carga_horaria_semanal ?? null;
                                        $horas = $cargaMin !== null ? floor($cargaMin / 60) : null;
                                        $minutos = $cargaMin !== null ? ($cargaMin % 60) : null;
                                        $cargaLabel = $cargaMin === null ? '-' : ($horas > 0 ? "{$horas}h" : '') . ($minutos > 0 ? " {$minutos}min" : ($horas === 0 ? "{$minutos}min" : ''));
                                    ?>
                                    <tr>
                                        <td style="padding: 5px;"><strong><?php echo e($disciplina->nome); ?></strong></td>
                                        <td style="padding: 5px;">
                                            <?php if($professorAlocado): ?>
                                                <span class="badge bg-info"><?php echo e($professorAlocado->professor_nome); ?></span>
                                            <?php else: ?>
                                                <span class="text-muted" style="font-size: 0.75rem;">Sem professor</span>
                                            <?php endif; ?>
                                        </td>
                                        <td style="padding: 5px;">
                                            <small class="text-muted"><?php echo e(trim($cargaLabel)); ?></small>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 10px;">
                        Nenhuma disciplina atribuída
                    </p>
                <?php endif; ?>
            </div>
        </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/turmas/show.blade.php ENDPATH**/ ?>