

<?php $__env->startSection('title', 'Editar Turma - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Editar Turma</h4>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.turmas.update', $turma)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="nivel_ensino" class="form-label">Nível de Ensino <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="nivel_ensino" name="nivel_ensino" required>
                                <option value="">Selecione o nível...</option>
                                <option value="PRIMARIO" <?php echo e(old('nivel_ensino', $turma->nivel_ensino ?? 'PRIMARIO') === 'PRIMARIO' ? 'selected' : ''); ?>>Primário</option>
                                <option value="SECUNDARIO" <?php echo e(old('nivel_ensino', $turma->nivel_ensino ?? '') === 'SECUNDARIO' ? 'selected' : ''); ?>>Secundário</option>
                            </select>
                            <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="codigo" class="form-label">Classe <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['codigo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="codigo" name="codigo" required>
                                <option value="">Selecione a classe...</option>
                                <?php for($i = 1; $i <= 12; $i++): ?>
                                    <option value="<?php echo e($i); ?>ª Classe" <?php echo e(old('codigo', $turma->codigo) == $i.'ª Classe' ? 'selected' : ''); ?>>
                                        <?php echo e($i); ?>ª Classe
                                    </option>
                                <?php endfor; ?>
                            </select>
                            <?php $__errorArgs = ['codigo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="nome" class="form-label">Turma <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="nome" name="nome" required>
                                <option value="">Selecione a turma...</option>
                                <?php
                                    $nomeAtual = old('nome', $turma->nome ?? '');
                                    $nomeNormalizado = '';
                                    
                                    // Normalizar: extrair apenas a letra (A, B, C, etc.)
                                    if (!empty($nomeAtual)) {
                                        // Remover "Turma" do início (case insensitive)
                                        $temp = preg_replace('/^turma\s*/i', '', trim($nomeAtual));
                                        $temp = trim($temp);
                                        
                                        // Se ainda tiver mais de 1 caractere, extrair apenas a letra
                                        if (strlen($temp) > 1) {
                                            if (preg_match('/\b([A-L])\b/i', $temp, $matches)) {
                                                $nomeNormalizado = strtoupper($matches[1]);
                                            } else {
                                                // Tentar pegar o primeiro caractere se for uma letra
                                                $primeiroChar = strtoupper(substr($temp, 0, 1));
                                                if (in_array($primeiroChar, ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L'])) {
                                                    $nomeNormalizado = $primeiroChar;
                                                }
                                            }
                                        } else {
                                            // Se tiver apenas 1 caractere e for uma letra válida
                                            $tempUpper = strtoupper($temp);
                                            if (in_array($tempUpper, ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L'])) {
                                                $nomeNormalizado = $tempUpper;
                                            }
                                        }
                                    }
                                ?>
                                <?php $__currentLoopData = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($letra); ?>" <?php echo e($nomeNormalizado == $letra ? 'selected' : ''); ?>>
                                        Turma <?php echo e($letra); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="ano_letivo_id" class="form-label">Ano Letivo <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['ano_letivo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="ano_letivo_id" name="ano_letivo_id" required>
                                <option value="">Selecione...</option>
                                <?php $__currentLoopData = $anoLetivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ano->id); ?>" <?php echo e(old('ano_letivo_id', $turma->ano_letivo_id) == $ano->id ? 'selected' : ''); ?>>
                                        <?php echo e($ano->ano_inicial); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['ano_letivo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="capacidade_maxima" class="form-label">Capacidade Máxima</label>
                            <input type="number" class="form-control <?php $__errorArgs = ['capacidade_maxima'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="capacidade_maxima" name="capacidade_maxima" 
                                   value="<?php echo e(old('capacidade_maxima', $turma->capacidade_maxima ?? 35)); ?>" min="1">
                            <?php $__errorArgs = ['capacidade_maxima'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="Activa" name="Activa" 
                                   <?php echo e(old('Activa', $turma->ativa) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="Activa">
                                Turma Activa
                            </label>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="<?php echo e(route('admin.turmas.index')); ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left me-1"></i> Voltar
                        </a>
                        <button type="submit" class="btn btn-primary-custom">
                            <i class="bi bi-check-circle me-1"></i> Atualizar Turma
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
function initTurmaEditForm() {
    const nivelSelect = document.getElementById('nivel_ensino');
    const classeSelect = document.getElementById('codigo');
    const turmaSelect = document.getElementById('nome');
    if (!nivelSelect || !classeSelect) return;

    const codigoAtual = <?php echo json_encode(old('codigo', $turma->codigo), 512) ?>;
    const turmaAtualRaw = <?php echo json_encode(old('nome', $turma->nome), 512) ?>;
    const numeroClasseAtual = parseInt(String(codigoAtual).replace(/\D+/g, ''), 10);
    const valorClasseNormalizado = !isNaN(numeroClasseAtual) ? `${numeroClasseAtual}ª Classe` : (codigoAtual || '');

    function renderClasses() {
        const nivel = nivelSelect.value || 'PRIMARIO';
        const range = nivel === 'SECUNDARIO' ? { start: 7, end: 12 } : { start: 1, end: 6 };
        const valorAtual = classeSelect.value || valorClasseNormalizado;

        classeSelect.innerHTML = '<option value="">Selecione a classe...</option>';
        for (let i = range.start; i <= range.end; i++) {
            const value = `${i}ª Classe`;
            const option = document.createElement('option');
            option.value = value;
            option.textContent = value;
            if (valorAtual === value) {
                option.selected = true;
            }
            classeSelect.appendChild(option);
        }
    }

    function ajustarNivelPeloCodigo() {
        if (!isNaN(numeroClasseAtual)) {
            nivelSelect.value = numeroClasseAtual >= 7 ? 'SECUNDARIO' : 'PRIMARIO';
        }
    }

    function ajustarTurmaAtual() {
        if (!turmaSelect) return;
        
        // Se já houver um valor selecionado (do PHP), não fazer nada
        if (turmaSelect.value && turmaSelect.value !== '') {
            return;
        }
        
        let valor = (turmaAtualRaw || '').toString().trim();
        
        // Normalizar: remover "Turma" do início e espaços
        valor = valor.replace(/^turma\s*/i, '').trim();
        
        // Se ainda não tiver valor, tentar extrair a última letra
        if (!valor && turmaAtualRaw) {
            const match = turmaAtualRaw.toString().match(/\b([A-L])\b/i);
            if (match) valor = match[1].toUpperCase();
        }
        
        if (!valor) return;

        // Tentar definir diretamente pelo value (deve ser apenas a letra: A, B, C, etc.)
        const letraNormalizada = valor.toUpperCase();
        
        // Procurar pela letra no texto da opção
        Array.from(turmaSelect.options).forEach(option => {
            if (option.value === letraNormalizada) {
                option.selected = true;
                turmaSelect.value = letraNormalizada;
            }
        });
    }

    nivelSelect.addEventListener('change', function() {
        renderClasses();
    });

    // Executar imediatamente, mas ajustar turma apenas se não estiver selecionada
    ajustarNivelPeloCodigo();
    renderClasses();
    
    // Só ajustar turma se não houver valor selecionado
    if (!turmaSelect || !turmaSelect.value || turmaSelect.value === '') {
        ajustarTurmaAtual();
    }
}

window.initTurmaEditForm = initTurmaEditForm;

document.addEventListener('DOMContentLoaded', function() {
    initTurmaEditForm();
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/turmas/edit.blade.php ENDPATH**/ ?>