<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manutenção - Sistema em Manutenção</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body {
            background: #f5f5f5;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .maintenance-container {
            background: white;
            border-radius: 20px;
            padding: 3rem;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            max-width: 600px;
            text-align: center;
            animation: fadeIn 0.5s ease-in;
        }
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .maintenance-icon {
            font-size: 5rem;
            color: #667eea;
            margin-bottom: 1.5rem;
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.1);
            }
        }
        h1 {
            color: #333;
            font-weight: 700;
            margin-bottom: 1rem;
        }
        .message {
            color: #666;
            font-size: 1.1rem;
            line-height: 1.6;
            margin-bottom: 2rem;
        }
        .info-box {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 1rem;
            border-radius: 5px;
            margin-top: 1.5rem;
            text-align: left;
        }
        .info-box i {
            color: #667eea;
            margin-right: 0.5rem;
        }
    </style>
</head>
<body>
    <div class="maintenance-container">
        <div class="maintenance-icon">
            <i class="bi bi-tools"></i>
        </div>
        <h1>Sistema em Manutenção</h1>
        <div class="message">
            <?php echo e(\App\Models\Configuracao::get('manutencao_mensagem', 'O sistema está temporariamente indisponível para manutenção. Por favor, tente novamente mais tarde.')); ?>

        </div>
        
        <?php
            $dataFim = \App\Models\Configuracao::get('manutencao_data_fim', null);
        ?>
        
        <?php if($dataFim): ?>
            <div class="info-box">
                <i class="bi bi-calendar-check"></i>
                <strong>Previsão de retorno:</strong> <?php echo e(\Carbon\Carbon::parse($dataFim)->format('d/m/Y H:i')); ?>

            </div>
        <?php endif; ?>
        
        <div class="info-box mt-3">
            <i class="bi bi-info-circle"></i>
            <small>Estamos trabalhando para melhorar o sistema. Agradecemos sua compreensão.</small>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/manutencao.blade.php ENDPATH**/ ?>