

<?php $__env->startSection('title', 'Recuperação de Senha - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">
                <i class="bi bi-key-fill text-warning me-2"></i>
                Recuperação de Senha
            </h5>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('admin.password-reset.index')); ?>" class="row g-2">
                    <div class="col-md-10">
                        <input type="text" class="form-control form-control-sm" name="search" 
                               value="<?php echo e($search ?? ''); ?>" 
                               placeholder="Pesquisar por nome, email, código de estudante ou número de funcionário...">
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-sm btn-primary w-100">
                            <i class="bi bi-search"></i> Buscar
                        </button>
                    </div>
                    <?php if($search ?? false): ?>
                        <div class="col-12">
                            <a href="<?php echo e(route('admin.password-reset.index')); ?>" class="btn btn-sm btn-secondary">
                                <i class="bi bi-x-circle"></i> Limpar
                            </a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>

        <?php if($users && $users->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Nome</th>
                            <th style="padding: 6px;">Email</th>
                            <th style="padding: 6px;">Tipo</th>
                            <th style="padding: 6px;">Código/Número</th>
                            <th style="padding: 6px;">Status</th>
                            <th style="padding: 6px;">Acções</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td style="padding: 5px;"><?php echo e($user->name); ?></td>
                                <td style="padding: 5px;"><?php echo e($user->email); ?></td>
                                <td style="padding: 5px;">
                                    <?php
                                        $badgeColors = [
                                            'superadmin' => 'danger',
                                            'admin' => 'primary',
                                            'funcionario' => 'info',
                                            'professor' => 'success',
                                            'aluno' => 'warning',
                                        ];
                                        $badgeColor = $badgeColors[$user->tipo] ?? 'secondary';
                                        $tipoLabels = [
                                            'superadmin' => 'Superadmin',
                                            'admin' => 'Admin',
                                            'funcionario' => 'Funcionário',
                                            'professor' => 'Professor',
                                            'aluno' => 'Aluno',
                                        ];
                                        $tipoLabel = $tipoLabels[$user->tipo] ?? ucfirst($user->tipo);
                                    ?>
                                    <span class="badge bg-<?php echo e($badgeColor); ?>"><?php echo e($tipoLabel); ?></span>
                                </td>
                                <td style="padding: 5px;">
                                    <?php if($user->aluno): ?>
                                        <?php echo e($user->aluno->codigo_estudante); ?>

                                    <?php elseif($user->professor): ?>
                                        <?php echo e($user->professor->numero_funcionario); ?>

                                    <?php elseif($user->funcionario): ?>
                                        <?php echo e($user->funcionario->numero_funcionario); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <?php if($user->is_active): ?>
                                        <span class="badge bg-success">Activo</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactivo</span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <a href="<?php echo e(route('admin.password-reset.show', $user)); ?>" 
                                       class="btn btn-sm btn-warning" 
                                       style="padding: 2px 6px; font-size: 0.75rem;" 
                                       title="Redefinir Senha">
                                        <i class="bi bi-key"></i> Redefinir
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php elseif($search ?? false): ?>
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                Nenhum usuário encontrado com os critérios de busca.
            </div>
        <?php else: ?>
            <div class="alert alert-secondary">
                <i class="bi bi-info-circle me-2"></i>
                Use o campo de busca acima para encontrar usuários e redefinir suas senhas.
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/password-reset/index.blade.php ENDPATH**/ ?>