<?php $__env->startSection('title', 'Trabalhos/TPCs - Estudante'); ?>

<?php $__env->startSection('content'); ?>
<?php
    use Illuminate\Support\Facades\Storage;
?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-file-earmark-text text-info me-2"></i>
                Trabalhos e TPCs
            </h4>
            <div>
                <span class="badge bg-primary"><?php echo e($anoLetivoAtivo->ano ?? 'N/A'); ?></span>
            </div>
        </div>
    </div>
</div>

<?php if($trabalhos->count() > 0): ?>
    <div class="table-responsive">
        <table class="table table-bordered table-hover">
            <thead class="table-light">
                <tr>
                    <th>Título</th>
                    <th>Disciplina</th>
                    <th>Turma</th>
                    <th>Professor</th>
                    <th>Data Entrega</th>
                    <th>Acções</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $trabalhos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trabalho): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($trabalho->titulo); ?></td>
                        <td><?php echo e($trabalho->disciplina->nome); ?></td>
                        <td><?php echo e($trabalho->turma->codigo); ?> - <?php echo e($trabalho->turma->nome); ?></td>
                        <td><?php echo e($trabalho->professor->user->name ?? 'N/A'); ?></td>
                        <td><?php echo e($trabalho->data_entrega->format('d/m/Y')); ?></td>
                        <td>
                            <?php if($trabalho->arquivo): ?>
                                <div class="btn-group btn-group-sm" role="group">
                                    <a href="<?php echo e(route('aluno.trabalhos.visualizar', $trabalho)); ?>" target="_blank" class="btn btn-outline-info" title="Ver">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="<?php echo e(Storage::url($trabalho->arquivo)); ?>" download class="btn btn-outline-success" title="Download">
                                        <i class="bi bi-download"></i>
                                    </a>
                                </div>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php else: ?>
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhum trabalho atribuído ainda.
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/aluno/trabalhos.blade.php ENDPATH**/ ?>