<?php $__env->startSection('title', 'Alocar Professores - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;">Alocar Professores</h5>
                <small class="text-muted"><?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?><?php if($anoLetivo): ?> | <?php echo e($anoLetivo->ano); ?><?php endif; ?></small>
            </div>
            <a href="<?php echo e(route('admin.turmas.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="row">
            <!-- Professores Alocados -->
            <div class="col-md-6">
                <div class="mb-2">
                    <small class="text-muted" style="font-weight: 600;">Professores Alocados (<?php echo e($alocacoes->count()); ?>)</small>
                    </div>
                        <?php if($alocacoes->count() > 0): ?>
                            <div class="table-responsive">
                        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                                    <thead style="background-color: #f8f9fa;">
                                        <tr>
                                            <th style="padding: 6px;">Professor</th>
                                            <th style="padding: 6px;">Disciplina</th>
                                            <th style="padding: 6px;">Acções</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $alocacoesAgrupadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $professorId => $alocacoesProfessor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $primeiraAlocacao = $alocacoesProfessor->first();
                                                $totalDisciplinas = $alocacoesProfessor->count();
                                            ?>
                                            <?php $__currentLoopData = $alocacoesProfessor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $alocacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <?php if($index === 0): ?>
                                                        <td rowspan="<?php echo e($totalDisciplinas); ?>" class="align-middle" style="padding: 5px;">
                                                            <strong style="font-size: 0.85rem;"><?php echo e($primeiraAlocacao->professor_nome); ?></strong>
                                                            <?php if($totalDisciplinas > 1): ?>
                                                                <br><span style="font-size: 0.75rem; padding: 2px 6px; background: #e2e3e5; color: #383d41; border-radius: 3px;">
                                                                    <?php echo e($totalDisciplinas); ?> disciplinas
                                                                </span>
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                    <td style="padding: 5px;"><?php echo e($alocacao->disciplina_nome); ?></td>
                                                    <td style="padding: 5px;">
                                                        <form action="<?php echo e(route('admin.turmas.remover-professor', ['turmaId' => $turma->id, 'professorId' => $professorId])); ?>" 
                                                              method="POST" 
                                                              class="d-inline"
                                                              onsubmit="return confirm('Tem certeza que deseja remover <?php echo e($primeiraAlocacao->professor_nome); ?> da disciplina <?php echo e($alocacao->disciplina_nome); ?>?');">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <input type="hidden" name="disciplina_id" value="<?php echo e($alocacao->disciplina_id); ?>">
                                                            <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Remover">
                                                                <i class="bi bi-x-circle"></i>
                                                            </button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 10px;">
                                Nenhum professor alocado
                            </p>
                        <?php endif; ?>
            </div>

            <!-- Alocar Novo Professor -->
            <div class="col-md-6">
                <div class="mb-2">
                    <small class="text-muted" style="font-weight: 600;">Alocar Professor</small>
                    </div>
                <form action="<?php echo e(route('admin.turmas.alocar-professores.store', $turma)); ?>" method="POST" style="background: #f8f9fa; padding: 10px; border-radius: 4px;">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="ano_letivo_id" value="<?php echo e($anoLetivo->id); ?>">
                            
                    <div class="mb-2">
                        <label for="disciplina_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Disciplina <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['disciplina_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="disciplina_id" name="disciplina_id" required>
                            <option value="">Selecione...</option>
                                    <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($disciplina->id); ?>" <?php echo e(old('disciplina_id') == $disciplina->id ? 'selected' : ''); ?>>
                                            <?php echo e($disciplina->nome); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['disciplina_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                    <div class="mb-2">
                        <label for="professor_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Professor <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['professor_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="professor_id" name="professor_id" required disabled>
                            <option value="">Primeiro selecione uma disciplina</option>
                                    <?php $__currentLoopData = $professores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $professor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($professor->id); ?>" data-disciplinas="<?php echo e(json_encode($professoresPorDisciplina ?? [])); ?>" <?php echo e(old('professor_id') == $professor->id ? 'selected' : ''); ?>>
                                    <?php echo e($professor->user->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['professor_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                    <div class="mt-2">
                        <button type="submit" class="btn btn-sm btn-primary w-100">
                            Alocar Professor
                                </button>
                            </div>
                        </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const disciplinaSelect = document.getElementById('disciplina_id');
    const professorSelect = document.getElementById('professor_id');
    const anoLetivoId = <?php echo e($anoLetivo->id ?? 'null'); ?>;
    
    // Dados iniciais de todos os professores
    const todosProfessores = <?php echo json_encode($professores->map(function($p) {
        return ['id' => $p->id, 'name' => $p->user->name];
    })->values(), 512) ?>;
    
    // Dados de professores por disciplina
    const professoresPorDisciplina = <?php echo json_encode($professoresPorDisciplina ?? [], 15, 512) ?>;
    
    // Função para atualizar lista de professores
    function atualizarProfessores(disciplinaId) {
        // Limpar opções atuais (exceto a primeira)
        professorSelect.innerHTML = '<option value="">Selecione...</option>';
        professorSelect.disabled = true;
        
        if (!disciplinaId) {
            return;
        }
        
        // Buscar professores via AJAX
        fetch(`<?php echo e(route('admin.professores.por-disciplina')); ?>?disciplina_id=${disciplinaId}&ano_letivo_id=${anoLetivoId}`, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.professores && data.professores.length > 0) {
                data.professores.forEach(prof => {
                    const option = document.createElement('option');
                    option.value = prof.id;
                    option.textContent = prof.name;
                    professorSelect.appendChild(option);
                });
                professorSelect.disabled = false;
            } else {
                // Se não houver professores específicos, mostrar todos
                todosProfessores.forEach(prof => {
                    const option = document.createElement('option');
                    option.value = prof.id;
                    option.textContent = prof.name;
                    professorSelect.appendChild(option);
                });
                professorSelect.disabled = false;
            }
        })
        .catch(error => {
            console.error('Erro ao buscar professores:', error);
            // Em caso de erro, mostrar todos os professores
            todosProfessores.forEach(prof => {
                const option = document.createElement('option');
                option.value = prof.id;
                option.textContent = prof.name;
                professorSelect.appendChild(option);
            });
            professorSelect.disabled = false;
        });
    }
    
    // Event listener para mudança de disciplina
    disciplinaSelect.addEventListener('change', function() {
        const disciplinaId = this.value;
        atualizarProfessores(disciplinaId);
    });
    
    // Se já houver uma disciplina selecionada (old input), atualizar professores
    <?php if(old('disciplina_id')): ?>
        atualizarProfessores(<?php echo e(old('disciplina_id')); ?>);
        // Restaurar professor selecionado se houver
        <?php if(old('professor_id')): ?>
            setTimeout(() => {
                professorSelect.value = <?php echo e(old('professor_id')); ?>;
            }, 500);
        <?php endif; ?>
    <?php endif; ?>
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/turmas/alocar-professores.blade.php ENDPATH**/ ?>