

<?php $__env->startSection('title', 'Minhas Notas - Estudante'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-clipboard-check text-success me-2"></i>
                Minhas Notas
            </h4>
            <div>
                <a href="<?php echo e(route('aluno.folheto-aproveitamento')); ?>" class="btn btn-warning btn-sm me-2" target="_blank">
                    <i class="bi bi-file-text me-1"></i> Folheto de Aproveitamento
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Filtro por Ano Letivo -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('aluno.notas')); ?>" class="row g-3 align-items-end">
            <div class="col-md-4">
                <label for="ano_letivo_id" class="form-label">Ano Lectivo:</label>
                <select name="ano_letivo_id" id="ano_letivo_id" class="form-select" onchange="this.form.submit()">
                    <?php $__currentLoopData = $anosLetivos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $anoRaw = $ano->getRawOriginal('ano');
                            $anoFinal = strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[1] : $anoRaw;
                        ?>
                        <option value="<?php echo e($ano->id); ?>" <?php echo e($anoLetivoAtivo && $anoLetivoAtivo->id == $ano->id ? 'selected' : ''); ?>>
                            <?php echo e($anoFinal); ?>

                            <?php if($ano->ativo): ?> (Ativo) <?php endif; ?>
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </form>
    </div>
</div>

<?php if($disciplinas->count() > 0): ?>
    <!-- Filtro por Trimestre -->
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('aluno.notas')); ?>" class="row g-3 align-items-end">
                <div class="col-md-4">
                    <label for="trimestre_id" class="form-label">Filtrar por Trimestre:</label>
                    <select name="trimestre_id" id="trimestre_id" class="form-select" onchange="this.form.submit()">
                        <option value="">Todos os Trimestres</option>
                        <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($trimestre->id); ?>" <?php echo e(request('trimestre_id') == $trimestre->id ? 'selected' : ''); ?>>
                                <?php echo e($trimestre->nome); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-8">
                    <button type="submit" class="btn btn-primary-custom">
                        <i class="bi bi-funnel me-1"></i> Filtrar
                    </button>
                    <?php if(request('trimestre_id')): ?>
                        <a href="<?php echo e(route('aluno.notas')); ?>" class="btn btn-outline-secondary">
                            <i class="bi bi-x-circle me-1"></i> Limpar Filtro
                        </a>
                    <?php endif; ?>
                </div>
            </form>
        </div>
    </div>

    <?php
        $trimestreSelecionado = request('trimestre_id') ? $trimestres->firstWhere('id', request('trimestre_id')) : null;
        $trimestresParaMostrar = $trimestreSelecionado ? collect([$trimestreSelecionado]) : $trimestres;
        
        // Verificar se todos os trimestres têm avaliações para mostrar resultados anuais
        $todosTrimestresCompletos = true;
        foreach ($disciplinas as $disciplina) {
            foreach ($trimestres as $trimestre) {
                $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                if (!$avaliacao || $avaliacao->mt === null) {
                    $todosTrimestresCompletos = false;
                    break 2;
                }
            }
        }
    ?>

    <!-- Notas por Trimestre -->
    <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-white">
                <h5 class="mb-0">
                    <i class="bi bi-book text-primary me-2"></i>
                    <?php echo e($disciplina->nome); ?>

                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-sm">
                        <thead class="table-light">
                            <tr>
                                <th rowspan="2" style="vertical-align: middle;">Trimestre</th>
                                <th colspan="3">A.Prática</th>
                                <th colspan="3">ACS</th>
                                <th rowspan="2" style="vertical-align: middle;">AT</th>
                                <th rowspan="2" style="vertical-align: middle;">MT</th>
                                <th rowspan="2" style="vertical-align: middle;">MFrD</th>
                            </tr>
                            <tr>
                                <th>1ª</th>
                                <th>2ª</th>
                                <th>MAP</th>
                                <th>1ª</th>
                                <th>2ª</th>
                                <th>MACS</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $trimestresParaMostrar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                                    $mfrd = $avaliacao->mfrd ?? null;
                                ?>
                                <tr>
                                    <td><strong><?php echo e($trimestre->nome); ?></strong></td>
                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : ''); ?>">
                                        <?php echo e($avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1) : '-'); ?>

                                    </td>
                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : ''); ?>">
                                        <?php echo e($avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1) : '-'); ?>

                                    </td>
                                    <td class="text-center font-weight-bold <?php echo e($avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : ''); ?>">
                                        <?php echo e($avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1) : '-'); ?>

                                    </td>
                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : ''); ?>">
                                        <?php echo e($avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1) : '-'); ?>

                                    </td>
                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : ''); ?>">
                                        <?php echo e($avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1) : '-'); ?>

                                    </td>
                                    <td class="text-center font-weight-bold <?php echo e($avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : ''); ?>">
                                        <?php echo e($avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1) : '-'); ?>

                                    </td>
                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : ''); ?>">
                                        <?php echo e($avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1) : '-'); ?>

                                    </td>
                                    <td class="text-center font-weight-bold <?php echo e($avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : ''); ?>">
                                        <?php echo e($avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0) : '-'); ?>

                                    </td>
                                    <td class="text-center font-weight-bold <?php echo e($mfrd !== null && !\App\Models\Avaliacao::isAprovado($mfrd) ? 'text-danger' : ''); ?>">
                                        <?php echo e($mfrd !== null ? number_format($mfrd, 0) : '-'); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <!-- Resultados Anuais/Finais -->
    <?php if($todosTrimestresCompletos && !$trimestreSelecionado): ?>
        <div class="card border-0 shadow-sm mt-4">
            <div class="card-header bg-warning bg-opacity-10">
                <h5 class="mb-0">
                    <i class="bi bi-trophy text-warning me-2"></i>
                    Resultados Anuais (Finais)
                </h5>
                <small class="text-muted">Disponíveis após a realização de todos os testes/avaliações</small>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Disciplina</th>
                                <th class="text-center">Média Final (MFrD)</th>
                                <th class="text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    // Buscar MFrD de qualquer avaliação da disciplina (é o mesmo em todas)
                                    $mfrd = null;
                                    foreach ($trimestres as $trimestre) {
                                        $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                                        if ($avaliacao && $avaliacao->mfrd !== null) {
                                            $mfrd = $avaliacao->mfrd;
                                            break;
                                        }
                                    }
                                    $aprovado = $mfrd !== null ? \App\Models\Avaliacao::isAprovado($mfrd) : false;
                                ?>
                                <tr>
                                    <td><strong><?php echo e($disciplina->nome); ?></strong></td>
                                    <td class="text-center">
                                        <?php if($mfrd !== null): ?>
                                            <span class="badge bg-<?php echo e($aprovado ? 'success' : 'danger'); ?> fs-5 px-3 py-2">
                                                <?php echo e(number_format($mfrd, 0)); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php if($mfrd !== null): ?>
                                            <span class="badge bg-<?php echo e($aprovado ? 'success' : 'danger'); ?> fs-6">
                                                <?php echo e($aprovado ? 'APROVADO' : 'REPROVADO'); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted">Aguardando cálculo</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php elseif(!$todosTrimestresCompletos && !$trimestreSelecionado): ?>
        <div class="alert alert-info mt-4">
            <i class="bi bi-info-circle me-2"></i>
            <strong>Resultados Anuais:</strong> Os resultados anuais estarão disponíveis após a realização de todos os testes/avaliações de todos os trimestres.
        </div>
    <?php endif; ?>
<?php else: ?>
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhuma nota registrada ainda.
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/aluno/notas.blade.php ENDPATH**/ ?>