<?php $__env->startSection('title', 'Inscrições - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Inscrições - Todos os Alunos</h5>
            <a href="<?php echo e(route('admin.inscricoes.renovados')); ?>" class="btn btn-sm btn-outline-success">Ver Renovados</a>
        </div>

        <form method="GET" action="<?php echo e(route('admin.inscricoes.index')); ?>" class="mb-2" style="display: flex; gap: 8px; align-items: end;">
            <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id" style="width: 150px;">
                <option value="">Todos os Anos</option>
                <?php $__currentLoopData = $anosLetivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($ano->id); ?>" <?php echo e($anoLetivoId == $ano->id ? 'selected' : ''); ?>>
                        <?php
                            $anoFinal = strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[1] : $ano->ano;
                        ?>
                        <?php echo e($anoFinal); ?>

                        <?php if($ano->ativo): ?> (Activo) <?php endif; ?>
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <input type="text" class="form-control form-control-sm" id="search" name="search" 
                   value="<?php echo e(request('search')); ?>" placeholder="Pesquisar..." style="flex: 1;">
            <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
            <?php if(request('search') || request('ano_letivo_id')): ?>
                <a href="<?php echo e(route('admin.inscricoes.index')); ?>" class="btn btn-sm btn-secondary">Limpar</a>
            <?php endif; ?>
        </form>

        <?php if($anoLetivoSelecionado): ?>
            <?php
                $anoFinal = strpos($anoLetivoSelecionado->ano, '/') !== false ? explode('/', $anoLetivoSelecionado->ano)[1] : $anoLetivoSelecionado->ano;
            ?>
            <div class="mb-2" style="font-size: 0.85rem; color: #6c757d;">
                Ano Lectivo: <strong><?php echo e($anoFinal); ?></strong> | Total: <strong><?php echo e($alunosNaoRenovadosPaginated->total()); ?></strong>
            </div>
        <?php endif; ?>

        <div class="js-ajax-pagination">
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;">Código</th>
                        <th style="padding: 6px;">Nome</th>
                        <th style="padding: 6px;">Turma Anterior</th>
                        <th style="padding: 6px;">Classe</th>
                        <th style="padding: 6px;">Status</th>
                        <th style="padding: 6px;">Acções</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $alunosNaoRenovadosPaginated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $aluno = $item['aluno'];
                            $turmaAnterior = $item['turma_anterior'];
                            $status = $item['status'];
                            $classeAtual = $turmaAnterior ? preg_match('/(\d+)/', $turmaAnterior->codigo, $matches) ? $matches[1] : 'N/A' : 'N/A';
                        ?>
                        <tr>
                            <td style="padding: 5px;"><?php echo e($aluno->codigo_estudante ?? 'N/A'); ?></td>
                            <td style="padding: 5px;"><?php echo e($aluno->user->name); ?></td>
                            <td style="padding: 5px;">
                                <?php if($turmaAnterior): ?>
                                    <?php echo e($turmaAnterior->codigo); ?> - <?php echo e($turmaAnterior->nome); ?>

                                <?php else: ?>
                                    <span style="color: #999;">Sem turma</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;">
                                <?php if($classeAtual != 'N/A'): ?>
                                    <?php echo e($classeAtual); ?>ª Classe
                                <?php else: ?>
                                    <span style="color: #999;">-</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;">
                                <?php if($status == 'aprovado'): ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Aprovado</span>
                                <?php elseif($status == 'reprovado'): ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Reprovado</span>
                                <?php else: ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #e2e3e5; color: #383d41; border-radius: 3px;">Sem Avaliação</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;">
                                <?php if($anoLetivoId && $anoLetivoAtual && $anoLetivoAtual->id != $anoLetivoId): ?>
                                    <a href="<?php echo e(route('admin.inscricoes.renovar', ['aluno' => $aluno, 'ano_letivo_anterior_id' => $anoLetivoId])); ?>" 
                                       class="btn btn-sm" style="padding: 2px 8px; font-size: 0.75rem; background: #0d6efd; color: #fff; border: none; border-radius: 3px;">
                                        Renovar
                                    </a>
                                <?php else: ?>
                                    <span style="color: #999;">-</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center" style="padding: 20px; color: #6c757d;">
                                <?php if($anoLetivoSelecionado): ?>
                                    Nenhum aluno não renovado encontrado.
                                <?php else: ?>
                                    Selecione um ano letivo de referência para ver os alunos.
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                </table>
            </div>

            <?php if(method_exists($alunosNaoRenovadosPaginated, 'links')): ?>
                <div class="mt-3">
                    <?php echo e($alunosNaoRenovadosPaginated->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/inscricoes/index.blade.php ENDPATH**/ ?>