<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cartões de Estudantes</title>
    <style>
        <?php
            $cp = $configuracao['cor_principal'] ?? '#1a237e';
            $cs = $configuracao['cor_secundaria'] ?? '#64b5f6';
            $cd = $configuracao['cor_destaque'] ?? '#ffb300';
        ?>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { background-color: #f5f5f5; padding: 20px; font-family: Arial, Helvetica, sans-serif; }
        @page { size: 85.60mm 53.98mm; margin: 0; }
        .cartao-container { width: 85.60mm; height: 53.98mm; background: #fff; border-radius: 12px; position: relative; box-shadow: 0 4px 12px rgba(0,0,0,0.15); overflow: hidden; }
        .decoracao-canto-inferior { position: absolute; bottom: 0; right: 0; width: 40mm; height: 25mm; z-index: 1; }
        .forma-azul-claro { fill: <?php echo e($cs); ?>; opacity: 0.85; }
        .linha-dourada { stroke: <?php echo e($cd); ?>; stroke-width: 1.2; fill: none; opacity: 1; }
        .detalhe-dourado { fill: <?php echo e($cd); ?>; opacity: 0.8; }
        .header-section { position: absolute; top: 3mm; left: 3mm; z-index: 2; width: 45mm; }
        .logo-container { display: flex; flex-direction: column; align-items: flex-start; }
        .logo-icon { width: 38mm; height: 38mm; margin-bottom: 1.5mm; }
        .escola-nome { font-size: 7pt; font-weight: bold; color: <?php echo e($cp); ?>; text-transform: uppercase; letter-spacing: 0.5px; line-height: 1.3; margin-bottom: 0.5mm; }
        .escola-slogan { font-size: 5.5pt; color: <?php echo e($cp); ?>; text-transform: uppercase; letter-spacing: 0.3px; line-height: 1.2; }
        .foto-section { position: absolute; top: 3mm; right: 3mm; width: 25mm; height: 30mm; z-index: 2; background: #fff; border-radius: 4px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); display: flex; align-items: center; justify-content: center; }
        .foto-section img { width: 100%; height: 100%; object-fit: cover; }
        .foto-placeholder { width: 100%; height: 100%; background: linear-gradient(135deg, <?php echo e($cs); ?> 0%, <?php echo e($cp); ?> 100%); opacity: 0.2; display: flex; align-items: center; justify-content: center; color: <?php echo e($cp); ?>; font-size: 5pt; text-align: center; padding: 2mm; }
        .faixa-inferior { position: absolute; bottom: 0; left: 0; right: 0; background: <?php echo e($cp); ?>; padding: 4mm 3mm 2.5mm 3mm; z-index: 3; min-height: 15mm; border-radius: 0 0 12px 12px; }
        .onda-fundo { position: absolute; top: -2mm; left: 0; right: 0; width: 100%; height: 3mm; z-index: 1; overflow: visible; }
        .onda-fundo svg { width: 100%; height: 100%; }
        .onda-principal { fill: <?php echo e($cd); ?>; }
        .onda-secundaria { fill: <?php echo e($cd); ?>; opacity: 0.7; }
        .onda-destaque { fill: none; stroke: <?php echo e($cd); ?>; stroke-width: 2; }
        .faixa-content { position: relative; z-index: 10; color: #fff; text-shadow: 0 1px 3px rgba(0,0,0,0.5); }
        .faixa-nome { font-size: 8pt; font-weight: bold; text-transform: uppercase; line-height: 1.2; letter-spacing: 0.3px; margin-bottom: 1mm; border-bottom: 1px solid <?php echo e($cd); ?>; padding-bottom: 0.8mm; }
        .faixa-info-container { display: flex; justify-content: flex-start; gap: 4mm; margin-bottom: 0.8mm; font-size: 6pt; }
        .info-card { display: flex; align-items: center; gap: 1mm; }
        .info-card-label { font-weight: 600; }
        .info-card-value { font-weight: normal; }
        .faixa-codigo { font-size: 6pt; font-weight: 600; }
        .cartao-verso { width: 85.60mm; height: 53.98mm; background: linear-gradient(160deg, #fff 0%, #f0f4f8 100%); border-radius: 12px; position: relative; box-shadow: 0 4px 16px rgba(0,0,0,0.12); overflow: hidden; border: 2px solid <?php echo e($cd); ?>; }
        .verso-onda-sup-esq { position: absolute; top: 0; left: 0; width: 45mm; height: 36mm; z-index: 1; }
        .verso-onda-inf-dir { position: absolute; bottom: 0; right: 0; width: 46mm; height: 32mm; z-index: 1; }
        .verso-onda-meio { position: absolute; top: 50%; left: 0; right: 0; height: 8mm; transform: translateY(-50%); opacity: 0.18; z-index: 1; }
        .verso-qr { position: absolute; left: 50%; top: 50%; transform: translate(-50%, -50%); width: 22mm; height: 22mm; z-index: 2; background: #fff; padding: 2mm; border-radius: 8px; box-shadow: 0 3px 12px rgba(0,0,0,0.15); border: 2px solid <?php echo e($cd); ?>; }
        .verso-qr img { width: 100%; height: 100%; object-fit: contain; }
        .verso-texto { position: absolute; right: 3mm; top: 3mm; width: 48mm; z-index: 2; color: <?php echo e($cp); ?>; font-size: 6.5pt; line-height: 1.5; font-weight: 600; }
        .verso-ano, .verso-validade { font-weight: 700; margin-bottom: 1.2mm; letter-spacing: 0.3px; text-transform: uppercase; }
        .verso-aviso { position: absolute; bottom: 6.5mm; left: 4mm; right: 4mm; text-align: center; font-size: 5.5pt; line-height: 1.4; color: <?php echo e($cp); ?>; z-index: 2; font-weight: 600; }
        .verso-contacto { position: absolute; bottom: 2mm; left: 4mm; right: 4mm; text-align: center; font-size: 5.5pt; font-weight: 700; color: <?php echo e($cp); ?>; z-index: 2; letter-spacing: 0.2px; padding: 1mm 0; border-top: 1px solid rgba(0,0,0,0.08); }
        @media print {
            * { -webkit-print-color-adjust: exact !important; print-color-adjust: exact !important; color-adjust: exact !important; }
            body { background: white; padding: 0; margin: 0; }
            .cartao-container { page-break-after: always; margin: 0 auto; box-shadow: none; border: none; }
            .faixa-inferior { background: <?php echo e($cp); ?> !important; }
            .onda-principal, .onda-secundaria { fill: <?php echo e($cd); ?> !important; }
            .onda-destaque { stroke: <?php echo e($cd); ?> !important; }
            .faixa-content { color: #fff !important; }
            .cartao-verso { page-break-after: always; margin: 0 auto; box-shadow: none; background: linear-gradient(160deg, #fff 0%, #f0f4f8 100%) !important; border: 2px solid <?php echo e($cd); ?> !important; }
            .verso-qr { border: 2px solid <?php echo e($cd); ?> !important; }
            .no-print { display: none !important; }
        }
        .print-btn { display: block; width: 200px; margin: 20px auto; padding: 10px 15px; background: <?php echo e($cp); ?>; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; text-align: center; }
        .print-btn:hover { background: <?php echo e($cs); ?>; }
        @media screen {
            .cartao-container { margin: 0 auto; }
            .cartao-verso { margin: 20px auto 0; }
        }
    </style>
</head>
<body>
    <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $__env->make('admin.alunos.partials.cartao-single', [
            'aluno' => $aluno,
            'configuracao' => $configuracao,
            'anoLetivo' => $anoLetivo,
            'logotipoBase64' => $logotipoBase64 ?? null,
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php if(empty($download)): ?>
        <button class="print-btn no-print" onclick="window.print()">Imprimir todos os cartões</button>
    <?php endif; ?>
</body>
</html>
<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/alunos/cartoes-multi.blade.php ENDPATH**/ ?>