

<?php $__env->startSection('title', 'Erros do Sistema - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Erros do Sistema</h5>
            <div>
                <a href="<?php echo e(route('superadmin.logs.index')); ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-arrow-left"></i> Voltar aos Logs
                </a>
            </div>
        </div>

        <div class="alert alert-warning">
            <i class="bi bi-info-circle"></i> Mostrando os últimos 100 erros encontrados no arquivo de log do Laravel.
        </div>

        <?php if(empty($erros)): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle"></i> Nenhum erro encontrado no sistema!
            </div>
        <?php else: ?>
            <div class="card">
                <div class="card-body">
                    <?php $__currentLoopData = $erros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $erro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-3 p-3 border rounded" style="background: #fff3cd;">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <strong style="color: #856404;">Erro #<?php echo e(count($erros) - $index); ?></strong>
                            </div>
                            <pre style="font-size: 0.75rem; white-space: pre-wrap; word-wrap: break-word; max-height: 400px; overflow-y: auto; background: #f8f9fa; padding: 10px; border-radius: 4px;"><?php echo e($erro); ?></pre>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/superadmin/logs/erros.blade.php ENDPATH**/ ?>