

<?php $__env->startSection('title', 'Atividade e Logins - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Último Login, Usuários Online e Tentativas de Login</h5>
            <form method="GET" class="d-flex gap-2 align-items-center">
                <label class="form-label mb-0" style="font-size: 0.85rem;">Limite:</label>
                <select name="limite" class="form-select form-select-sm" style="width: auto;" onchange="this.form.submit()">
                    <option value="20" <?php echo e($limite == 20 ? 'selected' : ''); ?>>20</option>
                    <option value="50" <?php echo e($limite == 50 ? 'selected' : ''); ?>>50</option>
                    <option value="100" <?php echo e($limite == 100 ? 'selected' : ''); ?>>100</option>
                    <option value="200" <?php echo e($limite == 200 ? 'selected' : ''); ?>>200</option>
                </select>
            </form>
        </div>

        
        <div class="row mb-3">
            <div class="col-md-4">
                <div class="card border-primary">
                    <div class="card-body py-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1" style="font-size: 0.8rem;">Últimos logins</h6>
                                <span class="h4 mb-0"><?php echo e($ultimosLogins->count()); ?></span>
                            </div>
                            <i class="bi bi-box-arrow-in-right text-primary" style="font-size: 2rem;"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-success">
                    <div class="card-body py-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1" style="font-size: 0.8rem;">Usuários online (<?php echo e($minutosOnline); ?> min)</h6>
                                <span class="h4 mb-0"><?php echo e($onlineComAtividade->count()); ?></span>
                            </div>
                            <i class="bi bi-person-check text-success" style="font-size: 2rem;"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-danger">
                    <div class="card-body py-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1" style="font-size: 0.8rem;">Tentativas falhas</h6>
                                <span class="h4 mb-0"><?php echo e($tentativasFalhas->count()); ?></span>
                            </div>
                            <i class="bi bi-exclamation-triangle text-danger" style="font-size: 2rem;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="card mb-3" style="font-size: 0.85rem;">
            <div class="card-header bg-success text-white">
                <i class="bi bi-person-check"></i> <strong>Usuários Online</strong>
                <span class="badge bg-light text-dark ms-2"><?php echo e($onlineComAtividade->count()); ?></span>
            </div>
            <div class="card-body">
                <?php if($onlineComAtividade->isEmpty()): ?>
                    <p class="text-muted mb-0">Nenhum usuário online nos últimos <?php echo e($minutosOnline); ?> minutos.</p>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="padding: 6px;">Usuário</th>
                                    <th style="padding: 6px;">Tipo</th>
                                    <th style="padding: 6px;">Última atividade</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $onlineComAtividade; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="padding: 5px;"><?php echo e($item['user']->name); ?></td>
                                        <td style="padding: 5px;">
                                            <span class="badge bg-secondary"><?php echo e($item['user']->tipo); ?></span>
                                        </td>
                                        <td style="padding: 5px;"><?php echo e(\Carbon\Carbon::createFromTimestamp($item['last_activity'])->format('d/m/Y H:i:s')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="card mb-3" style="font-size: 0.85rem;">
            <div class="card-header bg-primary text-white">
                <i class="bi bi-box-arrow-in-right"></i> <strong>Últimos Logins</strong>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered mb-0">
                        <thead class="table-light">
                            <tr>
                                <th style="padding: 6px;">Data/Hora</th>
                                <th style="padding: 6px;">Usuário</th>
                                <th style="padding: 6px;">Login usado</th>
                                <th style="padding: 6px;">IP</th>
                                <th style="padding: 6px;">Último login (perfil)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $ultimosLogins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attempt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td style="padding: 5px;"><?php echo e($attempt->created_at->format('d/m/Y H:i:s')); ?></td>
                                    <td style="padding: 5px;">
                                        <?php if($attempt->user): ?>
                                            <?php echo e($attempt->user->name); ?>

                                        <?php else: ?>
                                            <span class="text-muted">—</span>
                                        <?php endif; ?>
                                    </td>
                                    <td style="padding: 5px;"><code><?php echo e($attempt->login); ?></code></td>
                                    <td style="padding: 5px;"><?php echo e($attempt->ip_address ?? '—'); ?></td>
                                    <td style="padding: 5px;">
                                        <?php if($attempt->user && $attempt->user->last_login_at): ?>
                                            <?php echo e($attempt->user->last_login_at->format('d/m/Y H:i')); ?>

                                        <?php else: ?>
                                            —
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted py-4">Nenhum login registrado.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        
        <div class="card mb-3" style="font-size: 0.85rem;">
            <div class="card-header bg-danger text-white">
                <i class="bi bi-exclamation-triangle"></i> <strong>Tentativas de Login Falhadas</strong>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered mb-0">
                        <thead class="table-light">
                            <tr>
                                <th style="padding: 6px;">Data/Hora</th>
                                <th style="padding: 6px;">Login tentado</th>
                                <th style="padding: 6px;">Motivo</th>
                                <th style="padding: 6px;">IP</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $tentativasFalhas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attempt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td style="padding: 5px;"><?php echo e($attempt->created_at->format('d/m/Y H:i:s')); ?></td>
                                    <td style="padding: 5px;"><code><?php echo e($attempt->login); ?></code></td>
                                    <td style="padding: 5px;">
                                        <?php if($attempt->motivo === 'credenciais_invalidas'): ?>
                                            <span class="badge bg-warning text-dark">Credenciais inválidas</span>
                                        <?php elseif($attempt->motivo === 'conta_desativada'): ?>
                                            <span class="badge bg-secondary">Conta desativada</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary"><?php echo e($attempt->motivo ?? '—'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td style="padding: 5px;"><?php echo e($attempt->ip_address ?? '—'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">Nenhuma tentativa falha registrada.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/atividade-logins.blade.php ENDPATH**/ ?>