

<?php $__env->startSection('title', 'Administração - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Administração</h5>
            <a href="<?php echo e(route('admin.funcionarios.create')); ?>" class="btn btn-sm btn-primary">
                <i class="bi bi-plus-circle"></i> Novo
            </a>
        </div>

        <form method="GET" action="<?php echo e(route('admin.funcionarios.index')); ?>" class="mb-2" style="display: flex; gap: 8px;">
            <input type="text" class="form-control form-control-sm" name="search" 
                   value="<?php echo e(request('search')); ?>" placeholder="Pesquisar..." style="flex: 1;">
            <button type="submit" class="btn btn-sm btn-primary">Buscar</button>
            <?php if(request('search')): ?>
                <a href="<?php echo e(route('admin.funcionarios.index')); ?>" class="btn btn-sm btn-secondary">Limpar</a>
            <?php endif; ?>
        </form>

        <div class="js-ajax-pagination">
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;"><?php echo e(__('common.code')); ?></th>
                        <th style="padding: 6px;"><?php echo e(__('common.name')); ?></th>
                        <th style="padding: 6px;"><?php echo e(__('common.email')); ?></th>
                        <th style="padding: 6px;">Permissões</th>
                        <th style="padding: 6px;"><?php echo e(__('common.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $funcionarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $funcionario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td style="padding: 5px;">
                                <?php if($funcionario->numero_funcionario): ?>
                                    <span style="font-weight: 600;"><?php echo e($funcionario->numero_funcionario); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;"><?php echo e($funcionario->user->name ?? '-'); ?></td>
                            <td style="padding: 5px;"><?php echo e($funcionario->user->email ?? '-'); ?></td>
                            <td style="padding: 5px;">
                                <?php
                                    $permissoes = $funcionario->getPermissoesAtivas();
                                    $total = count($permissoes);
                                ?>
                                <?php if($total > 0): ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px; font-weight: 600;" title="<?php echo e(implode(', ', $permissoes)); ?>">
                                        <?php echo e($total); ?> permissão(ões)
                                    </span>
                                <?php else: ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">
                                        Sem permissões
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;">
                                <div style="display: flex; gap: 4px;">
                                    <a href="<?php echo e(route('admin.funcionarios.edit', $funcionario)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.funcionarios.toggle-status', $funcionario)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: <?php echo e($funcionario->user && $funcionario->user->is_active ? '#fff3cd' : '#d4edda'); ?>; color: <?php echo e($funcionario->user && $funcionario->user->is_active ? '#856404' : '#155724'); ?>; border: none;" title="<?php echo e($funcionario->user && $funcionario->user->is_active ? 'Bloquear' : 'Ativar'); ?>">
                                            <i class="bi bi-<?php echo e($funcionario->user && $funcionario->user->is_active ? 'lock' : 'unlock'); ?>"></i>
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.funcionarios.destroy', $funcionario)); ?>" method="POST" class="d-inline delete-form"
                                          data-id="<?php echo e($funcionario->id); ?>"
                                          data-confirm="Tem certeza que deseja eliminar este funcionário? Esta ação não pode ser desfeita.">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center" style="padding: 20px; color: #999;">
                                Nenhum funcionário encontrado.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                </table>
            </div>
            
            <?php if(method_exists($funcionarios, 'links')): ?>
                <div class="mt-3">
                    <?php echo e($funcionarios->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
        </div>

    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Interceptar formulários de delete
    document.querySelectorAll('.delete-form').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const confirmMsg = this.getAttribute('data-confirm');
            if (!confirm(confirmMsg)) {
                return false;
            }
            
            const formData = new FormData(this);
            const row = this.closest('tr');
            const url = this.action;
            
            // Mostrar loading
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalHTML = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i>';
            
            fetch(url, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': formData.get('_token'),
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                },
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.message || 'Erro ao processar requisição');
                    });
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    // Remover linha da tabela com animação
                    row.style.transition = 'opacity 0.3s';
                    row.style.opacity = '0';
                    setTimeout(function() {
                        row.remove();
                        // Verificar se a tabela ficou vazia
                        const tbody = document.querySelector('tbody');
                        if (tbody && tbody.children.length === 0) {
                            tbody.innerHTML = '<tr><td colspan="5" class="text-center" style="padding: 20px; color: #999;">Nenhum funcionário encontrado.</td></tr>';
                        }
                    }, 300);
                } else {
                    alert('Erro: ' + (data.message || 'Erro desconhecido'));
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalHTML;
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                alert('Erro: ' + (error.message || 'Erro ao eliminar funcionário. Por favor, tente novamente.'));
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalHTML;
            });
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/funcionarios/index.blade.php ENDPATH**/ ?>