<?php $__env->startSection('title', 'Eventos - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Eventos</h5>
            <?php if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_eventos')): ?>
                <a href="<?php echo e(route('eventos.create')); ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-plus-circle"></i> Agendar Evento
                </a>
            <?php endif; ?>
        </div>

        <?php if(isset($eventos) && $eventos->count() > 0): ?>
            <div class="js-ajax-pagination">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Título</th>
                            <th style="padding: 6px;">Data</th>
                            <th style="padding: 6px;">Hora</th>
                            <th style="padding: 6px;">Tipo</th>
                            <th style="padding: 6px;">Status</th>
                            <?php if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_eventos')): ?>
                                <th style="padding: 6px;">Acções</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($evento->cancelado ? 'table-secondary' : ''); ?>">
                                <td style="padding: 5px;">
                                    <strong><?php echo e($evento->titulo); ?></strong>
                                    <?php if($evento->descricao): ?>
                                        <br><small class="text-muted" style="font-size: 0.75rem;"><?php echo e(Str::limit($evento->descricao, 50)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;"><?php echo e($evento->data->format('d/m/Y')); ?></td>
                                <td style="padding: 5px;">
                                    <?php if($evento->hora_inicio): ?>
                                        <?php echo e($evento->hora_inicio->format('H:i')); ?><?php if($evento->hora_fim): ?> - <?php echo e($evento->hora_fim->format('H:i')); ?><?php endif; ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px;"><?php echo e($evento->tipo); ?></span>
                                    <?php if($evento->turma): ?>
                                        <br><small style="font-size: 0.7rem;"><?php echo e($evento->turma->codigo); ?> - <?php echo e($evento->turma->nome); ?></small>
                                    <?php endif; ?>
                                    <?php if($evento->disciplina): ?>
                                        <br><small style="font-size: 0.7rem;"><?php echo e($evento->disciplina->nome); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <?php if($evento->cancelado): ?>
                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Cancelado</span>
                                    <?php else: ?>
                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activo</span>
                                    <?php endif; ?>
                                </td>
                                <?php if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_eventos')): ?>
                                    <td style="padding: 5px;">
                                        <div style="display: flex; gap: 4px;">
                                            <a href="<?php echo e(route('eventos.edit', $evento)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="<?php echo e(route('eventos.cancelar', $evento)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: <?php echo e($evento->cancelado ? '#d4edda' : '#fff3cd'); ?>; color: <?php echo e($evento->cancelado ? '#155724' : '#856404'); ?>; border: none;" title="<?php echo e($evento->cancelado ? 'Reativar' : 'Cancelar'); ?>">
                                                    <i class="bi bi-<?php echo e($evento->cancelado ? 'check-circle' : 'x-circle'); ?>"></i>
                                                </button>
                                            </form>
                                            <form action="<?php echo e(route('eventos.destroy', $evento)); ?>" method="POST" class="d-inline"
                                                  onsubmit="return confirm('Tem certeza que deseja eliminar este evento?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    </table>
                </div>
                
                <?php if(method_exists($eventos, 'links')): ?>
                    <div class="mt-3">
                        <?php echo e($eventos->appends(request()->query())->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div style="background: #f8f9fa; padding: 20px; border-radius: 4px; text-align: center; font-size: 0.85rem;">
                Nenhum evento registrado
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/eventos/index.blade.php ENDPATH**/ ?>