

<?php $__env->startSection('title', 'Controle de Lançamento de Notas - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-10">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Controle de Lançamento de Notas por Trimestre</h5>
        </div>
        
        <?php if($anoLetivo): ?>
        <div class="alert alert-info mb-3" style="font-size: 0.85rem; padding: 10px;">
            <i class="bi bi-info-circle"></i> <strong>Ano Letivo Ativo:</strong> <?php echo e($anoLetivo->ano); ?>

        </div>
        <?php endif; ?>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="<?php echo e(route('admin.configuracoes.lancamento-notas.update')); ?>">
                <?php echo csrf_field(); ?>

                <?php if($trimestres->isEmpty()): ?>
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle"></i> Nenhum trimestre encontrado para o ano letivo ativo.
                    </div>
                <?php else: ?>
                    <div class="mb-3">
                        <h6 style="font-size: 0.9rem; font-weight: 600; margin-bottom: 1rem;">Configuração por Trimestre</h6>
                        
                        <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-3 p-3 border rounded" style="background: white;">
                                <div class="form-check form-switch">
                                    <input type="hidden" name="trimestres[<?php echo e($trimestre->id); ?>]" value="0">
                                    <input class="form-check-input" type="checkbox" 
                                           id="trimestre_<?php echo e($trimestre->id); ?>" 
                                           name="trimestres[<?php echo e($trimestre->id); ?>]" 
                                           value="1"
                                           <?php echo e(($lancamentoPorTrimestre[$trimestre->id] ?? true) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="trimestre_<?php echo e($trimestre->id); ?>" style="font-size: 0.9rem;">
                                        <strong><?php echo e($trimestre->numero); ?>º Trimestre - <?php echo e($trimestre->nome); ?></strong>
                                    </label>
                                    <small class="form-text text-muted d-block" style="font-size: 0.75rem; margin-top: 3px;">
                                        <?php if($trimestre->data_inicio && $trimestre->data_fim): ?>
                                            Período: <?php echo e(\Carbon\Carbon::parse($trimestre->data_inicio)->format('d/m/Y')); ?> até <?php echo e(\Carbon\Carbon::parse($trimestre->data_fim)->format('d/m/Y')); ?>

                                        <?php endif; ?>
                                    </small>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="alert alert-info" style="font-size: 0.85rem; padding: 10px;">
                        <i class="bi bi-info-circle"></i> <strong>Informação:</strong> 
                        <ul class="mb-0 mt-2" style="padding-left: 20px;">
                            <li><strong>Liberado (marcado):</strong> Professores podem lançar e alterar notas normalmente neste trimestre.</li>
                            <li><strong>Trancado (desmarcado):</strong> Professores podem apenas visualizar as notas existentes deste trimestre, mas não podem alterá-las.</li>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="mt-3">
                    <button type="submit" class="btn btn-primary">Salvar Configurações</button>
                    <a href="<?php echo e(route('admin.gestao')); ?>" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/configuracoes-lancamento-notas.blade.php ENDPATH**/ ?>