

<?php $__env->startSection('title', 'Alocar Aluno - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-6 mx-auto">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Alocar Aluno a Turma</h5>
            <a href="<?php echo e(route('admin.alunos.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <div class="mb-3 text-muted small">
                    <strong><?php echo e($aluno->codigo_estudante ?? 'N/A'); ?></strong> - <?php echo e($aluno->user->name); ?>

                    <?php if($turmaAtual): ?>
                        <span class="badge bg-secondary ms-2"><?php echo e($turmaAtual->codigo); ?> - <?php echo e($turmaAtual->nome); ?></span>
                    <?php endif; ?>
                </div>

                <form method="POST" action="<?php echo e(route('admin.alunos.alocar.store', $aluno)); ?>">
                    <?php echo csrf_field(); ?>
                    
                    <div class="mb-3">
                        <label for="ano_letivo_id" class="form-label">Ano Lectivo <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['ano_letivo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="ano_letivo_id" name="ano_letivo_id" required>
                            <option value="">Selecione o Ano Lectivo</option>
                            <?php $__currentLoopData = $anosLetivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ano->id); ?>" <?php echo e(($anoLetivo && $anoLetivo->id == $ano->id) ? 'selected' : ''); ?>>
                                    <?php
                                        $anoFinal = strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[1] : $ano->ano;
                                    ?>
                                    <?php echo e($anoFinal); ?>

                                    <?php if($ano->ativo): ?> (Activo) <?php endif; ?>
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['ano_letivo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="mb-3">
                        <label for="turma_id" class="form-label">Turma <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="turma_id" name="turma_id" required <?php echo e(!$anoLetivo ? 'disabled' : ''); ?>>
                            <option value=""><?php echo e($anoLetivo ? 'Selecione a Turma' : 'Selecione o Ano Lectivo primeiro'); ?></option>
                            <?php if($anoLetivo && $turmas->count() > 0): ?>
                                <?php $__currentLoopData = $turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($turma->id); ?>" <?php echo e(old('turma_id') == $turma->id ? 'selected' : ''); ?>>
                                        <?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                        <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="bi bi-check-circle"></i> Confirmar
                        </button>
                        <a href="<?php echo e(route('admin.alunos.index')); ?>" class="btn btn-secondary btn-sm">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Atualizar turmas quando o ano letivo mudar
    document.getElementById('ano_letivo_id').addEventListener('change', function() {
        const anoLetivoId = this.value;
        const turmaSelect = document.getElementById('turma_id');
        
        if (anoLetivoId) {
            // Recarregar a página com o ano letivo selecionado para carregar as turmas
            const url = new URL(window.location.href);
            url.searchParams.set('ano_letivo_id', anoLetivoId);
            window.location.href = url.toString();
        } else {
            turmaSelect.innerHTML = '<option value="">Selecione o Ano Lectivo primeiro</option>';
            turmaSelect.disabled = true;
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/alunos/alocar.blade.php ENDPATH**/ ?>