<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Presença'); ?></title>
    <style>
        *, *::before, *::after { box-sizing: border-box; }
        html, body { margin: 0; padding: 0; height: 100%; height: 100dvh; overflow: hidden; font: 14px/1.4 -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif; background: #111; color: #fff; -webkit-tap-highlight-color: transparent; }
        body { display: flex; flex-direction: column; }
        .scanner-header { flex: 0 0 auto; display: flex; align-items: center; justify-content: space-between; padding: 8px 12px; background: #1a1a1a; border-bottom: 1px solid #333; }
        .scanner-header h1 { margin: 0; font-size: 1rem; font-weight: 600; }
        .scanner-header a { color: #6ea8fe; text-decoration: none; font-size: 0.85rem; }
        .scanner-header a:hover { text-decoration: underline; }
        #reader { flex: 1 1 0; min-height: 0; overflow: hidden; display: flex; align-items: center; justify-content: center; width: 100%; background: #1a1a1a; }
        #reader video, #reader img, #reader canvas { max-width: 100%; max-height: 100%; object-fit: contain; }
        #result { position: fixed; top: 10px; left: 50%; transform: translateX(-50%); z-index: 50; padding: 8px 16px; border-radius: 8px; font-size: 0.9rem; font-weight: 500; max-width: 90%; pointer-events: none; opacity: 0; transition: opacity 0.2s; }
        #result.show { opacity: 1; }
        #result.ok { background: #198754; color: #fff; }
        #result.err { background: #dc3545; color: #fff; }
    </style>
</head>
<body>
    <header class="scanner-header">
        <h1>Presença</h1>
        <a href="<?php echo $__env->yieldContent('list-url', route('admin.presenca-professor.index')); ?>">Lista</a>
    </header>
    <div id="reader"></div>
    <div id="result" role="status" aria-live="polite"></div>
    <?php echo $__env->yieldContent('content'); ?>
    <script src="https://unpkg.com/html5-qrcode@2.3.8/html5-qrcode.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/layouts/scanner.blade.php ENDPATH**/ ?>