

<?php $__env->startSection('title', 'Criar Turma - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-6 mx-auto">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Nova Turma</h5>
            <a href="<?php echo e(route('admin.turmas.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
        
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.turmas.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="mb-3">
                        <label for="nivel_ensino" class="form-label">Nível de Ensino <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="nivel_ensino" name="nivel_ensino" required>
                            <option value="">Selecione o nível...</option>
                            <option value="PRIMARIO" <?php echo e(old('nivel_ensino', 'PRIMARIO') === 'PRIMARIO' ? 'selected' : ''); ?>>Primário</option>
                            <option value="SECUNDARIO" <?php echo e(old('nivel_ensino') === 'SECUNDARIO' ? 'selected' : ''); ?>>Secundário</option>
                        </select>
                        <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="codigo" class="form-label">Classe <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['codigo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="codigo" name="codigo" required>
                            <option value="">Selecione a classe...</option>
                        </select>
                        <?php $__errorArgs = ['codigo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="nome" class="form-label">Turma <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="nome" name="nome" required>
                            <option value="">Selecione a turma...</option>
                            <?php $__currentLoopData = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($letra); ?>" <?php echo e(old('nome') == $letra ? 'selected' : ''); ?>>
                                    Turma <?php echo e($letra); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="ano_letivo_id" class="form-label">Ano Letivo <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['ano_letivo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="ano_letivo_id" name="ano_letivo_id" required>
                            <option value="">Selecione...</option>
                            <?php $__currentLoopData = $anoLetivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ano->id); ?>" <?php echo e(old('ano_letivo_id', $anoLetivoAtivo?->id) == $ano->id ? 'selected' : ''); ?>>
                                    <?php echo e($ano->ano_inicial); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['ano_letivo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="capacidade_maxima" class="form-label">Capacidade Máxima</label>
                        <input type="number" class="form-control form-control-sm <?php $__errorArgs = ['capacidade_maxima'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="capacidade_maxima" name="capacidade_maxima" 
                               value="<?php echo e(old('capacidade_maxima', 35)); ?>" min="1">
                        <?php $__errorArgs = ['capacidade_maxima'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3 form-check">
                        <input class="form-check-input" type="checkbox" id="Activa" name="Activa" 
                               <?php echo e(old('Activa', true) ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="Activa">
                            Turma Activa
                        </label>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="bi bi-check-circle"></i> Criar
                        </button>
                        <a href="<?php echo e(route('admin.turmas.index')); ?>" class="btn btn-secondary btn-sm">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
function initTurmaCreateForm() {
    const nivelSelect = document.getElementById('nivel_ensino');
    const classeSelect = document.getElementById('codigo');
    if (!nivelSelect || !classeSelect) return;

    const oldCodigo = <?php echo json_encode(old('codigo'), 15, 512) ?>;

    function renderClasses() {
        const nivel = nivelSelect.value || 'PRIMARIO';
        const range = nivel === 'SECUNDARIO' ? { start: 7, end: 12 } : { start: 1, end: 6 };

        classeSelect.innerHTML = '<option value="">Selecione a classe...</option>';
        for (let i = range.start; i <= range.end; i++) {
            const value = `${i}ª Classe`;
            const option = document.createElement('option');
            option.value = value;
            option.textContent = value;
            if (oldCodigo === value) {
                option.selected = true;
            }
            classeSelect.appendChild(option);
        }
    }

    nivelSelect.addEventListener('change', function() {
        renderClasses();
    });

    renderClasses();
}

window.initTurmaCreateForm = initTurmaCreateForm;

document.addEventListener('DOMContentLoaded', function() {
    initTurmaCreateForm();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/turmas/create.blade.php ENDPATH**/ ?>