<?php $__env->startSection('title', 'Alunos - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;"><?php echo e(__('common.students')); ?></h5>
            <div class="btn-group btn-group-sm">
                <a href="<?php echo e(route('admin.alunos.create')); ?>" class="btn btn-primary"><?php echo e(__('common.new_student')); ?></a>
                <a href="<?php echo e(route('admin.inscricoes.index')); ?>" class="btn btn-outline-success"><?php echo e(__('common.enrollments')); ?></a>
                <a href="<?php echo e(route('admin.cartoes-estudantes.index')); ?>" class="btn btn-outline-primary">Cartões de Estudantes</a>
            </div>
        </div>

        <form method="GET" action="<?php echo e(route('admin.alunos.index')); ?>" class="mb-2" style="display: flex; gap: 8px; align-items: end;">
            <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id" style="width: 150px;">
                <option value=""><?php echo e(__('common.all_years')); ?></option>
                <?php $__currentLoopData = $anosLetivos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($ano->id); ?>" <?php echo e(($anoLetivoId ?? null) == $ano->id ? 'selected' : ''); ?>>
                        <?php
                            if (strpos($ano->ano, '/') !== false) {
                                $partes = explode('/', $ano->ano);
                                $anoInicial = $partes[0];
                                $anoFinal = $partes[1];
                                $anoExibido = $anoInicial; // Mostrar ano inicial
                            } else {
                                $anoExibido = $ano->ano;
                            }
                        ?>
                        <?php echo e($anoExibido); ?>

                        <?php if($ano->ativo): ?> (<?php echo e(__('common.active')); ?>) <?php endif; ?>
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <input type="text" class="form-control form-control-sm" id="search" name="search" 
                   value="<?php echo e(request('search')); ?>" placeholder="<?php echo e(__('common.search')); ?>..." style="flex: 1;">
            <select class="form-select form-select-sm" id="classe" name="classe" style="width: 150px;">
                <option value=""><?php echo e(__('common.all_classes')); ?></option>
                <?php $__currentLoopData = $classes ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($classe); ?>" <?php echo e(request('classe') == $classe ? 'selected' : ''); ?>><?php echo e($classe); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <select class="form-select form-select-sm" id="turma" name="turma" style="width: 150px;">
                <option value=""><?php echo e(__('common.all_turmas')); ?></option>
                <?php $__currentLoopData = $turmas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($turma); ?>" <?php echo e(request('turma') == $turma ? 'selected' : ''); ?>><?php echo e($turma); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <button type="submit" class="btn btn-sm btn-primary"><?php echo e(__('common.filter')); ?></button>
            <?php if(request('search') || request('classe') || request('turma') || request('ano_letivo_id')): ?>
                <a href="<?php echo e(route('admin.alunos.index')); ?>" class="btn btn-sm btn-secondary"><?php echo e(__('common.clear')); ?></a>
            <?php endif; ?>
        </form>

        <div class="js-ajax-pagination">
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;"><?php echo e(__('common.code')); ?></th>
                        <th style="padding: 6px;"><?php echo e(__('common.name')); ?></th>
                        <th style="padding: 6px;"><?php echo e(__('common.class_turma')); ?></th>
                        <th style="padding: 6px;"><?php echo e(__('common.phone')); ?></th>
                        <th style="padding: 6px;"><?php echo e(__('common.status')); ?></th>
                        <th style="padding: 6px;"><?php echo e(__('common.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td style="padding: 5px;"><?php echo e($aluno->codigo_estudante); ?></td>
                            <td style="padding: 5px;"><?php echo e($aluno->user->name); ?></td>
                            <td style="padding: 5px;">
                                <?php if($aluno->turmas->count() > 0): ?>
                                    <?php $__currentLoopData = $aluno->turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px;"><?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <span style="color: #999;"><?php echo e(__('common.no_class')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;"><?php echo e($aluno->telefone ?? '-'); ?></td>
                            <td style="padding: 5px;">
                                <?php if($aluno->user && $aluno->user->is_active): ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;"><?php echo e(__('common.active')); ?></span>
                                <?php else: ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;"><?php echo e(__('common.blocked')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;">
                                <div style="display: flex; gap: 4px;">
                                    <a href="<?php echo e(route('admin.alunos.show', $aluno)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #e7f3ff; color: #0066cc; border: none;" title="<?php echo e(__('common.view')); ?>">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.alunos.edit', $aluno)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="<?php echo e(__('common.edit')); ?>">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.alunos.alocar', $aluno)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d1ecf1; color: #0c5460; border: none;" title="Alocar a Turma">
                                        <i class="bi bi-person-plus"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.alunos.toggle-status', $aluno)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: <?php echo e($aluno->user && $aluno->user->is_active ? '#fff3cd' : '#d4edda'); ?>; color: <?php echo e($aluno->user && $aluno->user->is_active ? '#856404' : '#155724'); ?>; border: none;" title="<?php echo e($aluno->user && $aluno->user->is_active ? __('common.block') : __('common.unblock')); ?>">
                                            <i class="bi bi-<?php echo e($aluno->user && $aluno->user->is_active ? 'lock' : 'unlock'); ?>"></i>
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.alunos.destroy', $aluno)); ?>" method="POST" class="d-inline delete-form"
                                          data-id="<?php echo e($aluno->id); ?>"
                                          data-confirm="Tem certeza que deseja eliminar este aluno? Esta acção não pode ser desfeita.">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center">Nenhum aluno encontrado</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                </table>
            </div>

            <?php if(method_exists($alunos, 'links')): ?>
                <div class="mt-3">
                    <?php echo e($alunos->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Interceptar formulários de delete
    document.querySelectorAll('.delete-form').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const confirmMsg = this.getAttribute('data-confirm');
            if (!confirm(confirmMsg)) {
                return false;
            }
            
            const formData = new FormData(this);
            const row = this.closest('tr');
            const url = this.action;
            
            // Mostrar loading
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalHTML = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i>';
            
            fetch(url, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': formData.get('_token'),
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                },
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.message || 'Erro ao processar requisição');
                    });
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    // Remover linha da tabela com animação
                    row.style.transition = 'opacity 0.3s';
                    row.style.opacity = '0';
                    setTimeout(function() {
                        row.remove();
                        // Verificar se a tabela ficou vazia
                        const tbody = document.querySelector('tbody');
                        if (tbody && tbody.children.length === 0) {
                            tbody.innerHTML = '<tr><td colspan="6" class="text-center">Nenhum aluno encontrado</td></tr>';
                        }
                    }, 300);
                } else {
                    alert('Erro: ' + (data.message || 'Erro desconhecido'));
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalHTML;
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                alert('Erro: ' + (error.message || 'Erro ao eliminar aluno. Por favor, tente novamente.'));
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalHTML;
            });
        });
    });
});
</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/alunos/index.blade.php ENDPATH**/ ?>