<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Folhetos de Aproveitamento - <?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?></title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Times New Roman', Times, serif;
        }
        
        @page {
            size: A4;
            margin: 0;
        }
        
        @media print {
            @page {
                margin: 0;
                size: A4;
            }
            
            html, body {
                margin: 0;
                padding: 0;
                width: 210mm;
                height: 297mm;
            }
        }
        
        body {
            background-color: #f5f5f5;
            color: #000;
            line-height: 1.4;
            padding: 20px;
        }
        
        .document {
            background-color: white;
            padding: 8mm;
            max-width: 100%;
            margin-bottom: 3mm;
            page-break-after: auto;
            position: relative;
            width: 210mm;
            height: 55mm;
            box-sizing: border-box;
            border: 1px solid #ddd;
        }
        
        .document:last-child {
            page-break-after: auto;
        }
        
        .document.single-page {
            page-break-after: auto;
            margin-bottom: 3mm;
            height: auto;
        }
        
        .document.hidden {
            display: none;
        }
        
        .checkbox-container {
            position: absolute;
            top: 5px;
            left: 5px;
            z-index: 10;
        }
        
        .checkbox-container input[type="checkbox"] {
            width: 16px;
            height: 16px;
            cursor: pointer;
        }
        
        .print-individual-btn {
            position: absolute;
            top: 5px;
            right: 5px;
            padding: 3px 8px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 3px;
            cursor: pointer;
            font-size: 10px;
            z-index: 10;
        }
        
        .print-individual-btn:hover {
            background-color: #218838;
        }
        
        .download-btn {
            position: absolute;
            top: 5px;
            right: 60px;
            padding: 3px 8px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 3px;
            cursor: pointer;
            font-size: 10px;
            z-index: 10;
            text-decoration: none;
            display: inline-block;
        }
        
        .download-btn:hover {
            background-color: #0056b3;
            color: white;
        }
        
        .header {
            margin-bottom: 4mm;
            text-align: center;
            line-height: 1.2;
        }
        
        .header-line {
            font-size: 8pt;
            margin-bottom: 1mm;
        }
        
        .escola-nome {
            font-weight: bold;
        }
        
        .info-header {
            font-size: 7pt;
            margin-top: 1mm;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 7pt;
            margin-bottom: 3mm;
        }
        
        table th,
        table td {
            border: 1px solid #000;
            padding: 2px;
            text-align: center;
        }
        
        table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .col-numero {
            width: 20px;
        }
        
        .col-nome {
            width: 120px;
            text-align: left;
            font-size: 6.5pt;
        }
        
        .col-genero {
            width: 25px;
        }
        
        .col-disciplina {
            width: 35px;
        }
        
        .col-media {
            width: 40px;
        }
        
        .col-classificacao {
            width: 100px;
        }
        
        .footer {
            text-align: center;
            margin-top: 2mm;
            font-size: 7pt;
        }
        
        .select-trimestre {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 10px;
            background-color: white;
            border: 2px solid #007bff;
            border-radius: 5px;
            z-index: 1000;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
        
        @media print {
            @page {
                margin: 0;
                size: A4;
            }
            
            * {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            html, body {
                margin: 0 !important;
                padding: 0 !important;
                width: 210mm !important;
                height: 297mm !important;
                background: white !important;
                overflow: hidden !important;
            }
            
            body {
                padding: 5mm !important;
            }
            
            .no-print {
                display: none !important;
            }
            
            .document {
                margin: 0 !important;
                margin-bottom: 2mm !important;
                padding: 5mm !important;
                width: 200mm !important;
                height: 55mm !important;
                page-break-after: auto !important;
                page-break-inside: avoid;
                box-shadow: none !important;
                overflow: hidden !important;
                border: 1px solid #000 !important;
            }
            
            .document.single-page {
                page-break-after: auto !important;
                margin-bottom: 2mm !important;
                height: 55mm !important;
            }
            
            .document:nth-child(5n) {
                page-break-after: always !important;
            }
            
            .document:last-child {
                page-break-after: auto !important;
            }
            
            table {
                page-break-inside: avoid;
                font-size: 6.5pt !important;
            }
            
            tr {
                page-break-inside: avoid;
            }
            
            .header {
                margin-bottom: 2mm !important;
            }
            
            .header-line {
                font-size: 7pt !important;
                margin-bottom: 0.5mm !important;
            }
            
            .info-header {
                font-size: 6.5pt !important;
            }
            
            .footer {
                margin-top: 1mm !important;
                font-size: 6.5pt !important;
            }
        }
        
        .print-controls {
            position: fixed;
            bottom: 20px;
            right: 20px;
            display: flex;
            flex-direction: column;
            gap: 10px;
            z-index: 1000;
        }
        
        .print-btn {
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
        }
        
        .print-btn:hover {
            background-color: #0056b3;
        }
        
        .print-btn.selected {
            background-color: #28a745;
        }
        
        .print-btn.selected:hover {
            background-color: #218838;
        }
        
        .print-btn.all {
            background-color: #6c757d;
        }
        
        .print-btn.all:hover {
            background-color: #5a6268;
        }
    </style>
</head>
<body>
    <div class="select-trimestre no-print">
        <form method="GET" style="display: flex; gap: 10px; align-items: center; flex-direction: column;">
            <input type="hidden" name="turma_id" value="<?php echo e($turma->id); ?>">
            <label for="trimestre"><strong>Trimestre:</strong></label>
            <select name="trimestre" id="trimestre" onchange="this.form.submit()" style="padding: 5px; width: 100%;">
                <option value="1" <?php echo e($trimestre->numero == 1 ? 'selected' : ''); ?>>1º Trimestre</option>
                <option value="2" <?php echo e($trimestre->numero == 2 ? 'selected' : ''); ?>>2º Trimestre</option>
                <option value="3" <?php echo e($trimestre->numero == 3 ? 'selected' : ''); ?>>3º Trimestre</option>
            </select>
        </form>
    </div>
    
    <?php $__currentLoopData = $folhetos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $folheto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="document" id="folheto-<?php echo e($index); ?>" data-index="<?php echo e($index); ?>">
            <div class="checkbox-container no-print">
                <input type="checkbox" class="folheto-checkbox" data-index="<?php echo e($index); ?>" onchange="updatePrintButtons()">
            </div>
            <a href="<?php echo e(route('admin.alunos.download-folheto', ['aluno_id' => $folheto['aluno']->id, 'trimestre' => $trimestre->numero])); ?>" 
               class="download-btn no-print" target="_blank" title="Download deste folheto">
                <i class="bi bi-download"></i> Download
            </a>
            <button class="print-individual-btn no-print" onclick="imprimirIndividual(<?php echo e($index); ?>)" title="Imprimir este folheto">
                <i class="bi bi-printer"></i> Imprimir
            </button>
            <div class="header">
                <div class="header-line escola-nome"><?php echo e(strtoupper($configuracao['escola'])); ?></div>
                <div class="header-line">Aproveitamento Pedagógico do <?php echo e($trimestre->numero); ?>º Trimestre</div>
                <div class="info-header">
                    <?php if($turma->codigo): ?>
                        <?php echo e(strtoupper($turma->codigo)); ?>

                    <?php endif; ?>
                    Turma: <?php echo e(strtoupper($turma->nome)); ?> | Ano Lectivo: <?php echo e($anoLetivo->ano_inicial ?? $anoLetivo->ano); ?>

                </div>
            </div>
            
            <table>
                <thead>
                    <tr>
                        <th class="col-numero">Nº</th>
                        <th class="col-nome">Nome Completo</th>
                        <th class="col-genero">Gén.</th>
                        <th colspan="<?php echo e($disciplinas->count()); ?>" style="text-align: center;">Médias por Disciplina</th>
                        <th class="col-media">Média Trimestral</th>
                        <th class="col-classificacao">Classificação</th>
                    </tr>
                    <tr>
                        <th></th>
                        <th></th>
                        <th></th>
                        <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $abreviacoes = [
                                    'Português' => 'Port.',
                                    'Matemática' => 'Mat.',
                                    'Ciências Naturais' => 'C. Nat.',
                                    'Ciências Sociais' => 'C. Soc.',
                                    'Educação Visual e Ofícios' => 'EVO',
                                    'Educação Física' => 'E. Fis.',
                                    'Física' => 'Físi',
                                    'História' => 'HIST',
                                    'Inglês' => 'Ingl.',
                                    'Química' => 'Quím.',
                                    'Biologia' => 'Biol.',
                                ];
                                $abrev = $abreviacoes[$disciplina->nome] ?? strtoupper(substr($disciplina->nome, 0, 5));
                            ?>
                            <th class="col-disciplina"><?php echo e($abrev); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo e($folheto['numero']); ?></td>
                        <td style="text-align: left;"><?php echo e(strtoupper($folheto['aluno']->user->name)); ?></td>
                        <td><?php echo e($folheto['aluno']->genero == 'M' ? 'H' : ($folheto['aluno']->genero == 'F' ? 'M' : '-')); ?></td>
                        <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <?php if(isset($folheto['mediasPorDisciplina'][$disciplina->id]) && $folheto['mediasPorDisciplina'][$disciplina->id] !== null): ?>
                                    <?php echo e($folheto['mediasPorDisciplina'][$disciplina->id]); ?>

                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <td>
                            <?php if($folheto['mediaTrimestralGeral'] !== null): ?>
                                <?php echo e($folheto['mediaTrimestralGeral']); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td><strong><?php echo e($folheto['classificacaoMedia'] ?? '-'); ?></strong></td>
                    </tr>
                </tbody>
            </table>
            
            <div class="footer">
                O(A) Director(a) de Turma
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    <div class="print-controls no-print">
        <button class="print-btn selected" onclick="imprimirSelecionados()" id="btn-selecionados">
            <i class="bi bi-check-square"></i> Imprimir Selecionados
        </button>
        <button class="print-btn all" onclick="imprimirTodos()" id="btn-todos">
            <i class="bi bi-printer"></i> Imprimir Todos
        </button>
    </div>
    
    <script>
        function imprimirIndividual(index) {
            // Esconder todos os folhetos
            document.querySelectorAll('.document').forEach(doc => {
                doc.classList.add('hidden');
            });
            
            // Mostrar apenas o folheto selecionado
            const folheto = document.getElementById('folheto-' + index);
            if (folheto) {
                folheto.classList.remove('hidden');
                folheto.classList.add('single-page');
            }
            
            // Imprimir
            window.print();
            
            // Restaurar visibilidade após impressão
            setTimeout(() => {
                document.querySelectorAll('.document').forEach(doc => {
                    doc.classList.remove('hidden', 'single-page');
                });
            }, 1000);
        }
        
        function imprimirSelecionados() {
            const checkboxes = document.querySelectorAll('.folheto-checkbox:checked');
            
            if (checkboxes.length === 0) {
                alert('Por favor, selecione pelo menos um folheto para imprimir.');
                return;
            }
            
            // Esconder todos
            document.querySelectorAll('.document').forEach(doc => {
                doc.classList.add('hidden');
            });
            
            // Mostrar apenas os selecionados (todos na mesma página)
            checkboxes.forEach(checkbox => {
                const index = checkbox.getAttribute('data-index');
                const folheto = document.getElementById('folheto-' + index);
                if (folheto) {
                    folheto.classList.remove('hidden');
                    folheto.classList.add('single-page');
                }
            });
            
            // Imprimir
            window.print();
            
            // Restaurar visibilidade após impressão
            setTimeout(() => {
                document.querySelectorAll('.document').forEach(doc => {
                    doc.classList.remove('hidden', 'single-page');
                });
            }, 1000);
        }
        
        function imprimirTodos() {
            // Todos os folhetos na mesma página
            document.querySelectorAll('.document').forEach(doc => {
                doc.classList.remove('hidden');
                doc.classList.add('single-page');
            });
            
            // Imprimir
            window.print();
            
            // Restaurar após impressão
            setTimeout(() => {
                document.querySelectorAll('.document').forEach(doc => {
                    doc.classList.remove('single-page');
                });
            }, 1000);
        }
        
        function updatePrintButtons() {
            const checked = document.querySelectorAll('.folheto-checkbox:checked').length;
            const btnSelecionados = document.getElementById('btn-selecionados');
            
            if (checked > 0) {
                btnSelecionados.textContent = `Imprimir Selecionados (${checked})`;
                btnSelecionados.disabled = false;
            } else {
                btnSelecionados.textContent = 'Imprimir Selecionados';
                btnSelecionados.disabled = false;
            }
        }
        
        // Inicializar
        document.addEventListener('DOMContentLoaded', function() {
            updatePrintButtons();
        });
    </script>
</body>
</html>

<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/alunos/folhetos-turma.blade.php ENDPATH**/ ?>