<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;
use App\Models\Funcionario;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

echo "=== TESTE DE PERMISSÕES DO FUNCIONÁRIO ===\n\n";

// Encontrar um funcionário
$funcionario = Funcionario::with('user')->first();

if (!$funcionario) {
    echo "❌ Nenhum funcionário encontrado!\n";
    exit;
}

$user = $funcionario->user;

echo "📋 DADOS DO FUNCIONÁRIO:\n";
echo "   Nome: {$user->name}\n";
echo "   Email: {$user->email}\n";
echo "   Tipo: {$user->tipo}\n";
echo "   ID do Funcionário: {$funcionario->id}\n\n";

echo "📊 PERMISSÕES NO BANCO DE DADOS (RAW):\n";
$permissoes = [
    'gerir_alunos',
    'gerir_professores',
    'gerir_turmas',
    'gerir_disciplinas',
    'gerir_mensalidades',
    'gerir_horarios',
    'gerir_eventos',
    'gerir_planos',
    'gerir_avaliacoes',
    'gerir_inscricoes',
];

foreach ($permissoes as $perm) {
    $valorRaw = DB::table('funcionarios')
        ->where('id', $funcionario->id)
        ->value($perm);
    $status = ($valorRaw == 1) ? '✅ SIM' : '❌ NÃO';
    echo "   {$perm}: {$status} (valor: {$valorRaw}, tipo: " . gettype($valorRaw) . ")\n";
}

echo "\n📦 PERMISSÕES NO MODELO (APÓS CAST):\n";
foreach ($permissoes as $perm) {
    $valor = $funcionario->getAttribute($perm);
    $status = ($valor === true) ? '✅ SIM' : '❌ NÃO';
    echo "   {$perm}: {$status} (valor: " . var_export($valor, true) . ", tipo: " . gettype($valor) . ")\n";
}

echo "\n🔍 TESTE temPermissao():\n";
foreach ($permissoes as $perm) {
    $resultado = $funcionario->temPermissao($perm);
    $status = $resultado ? '✅ SIM' : '❌ NÃO';
    echo "   temPermissao('{$perm}'): {$status}\n";
}

echo "\n👤 TESTE podeGerir() NO USER:\n";
// Garantir que o relacionamento está carregado
if (!$user->relationLoaded('funcionario')) {
    $user->load('funcionario');
}

foreach ($permissoes as $perm) {
    $resultado = $user->podeGerir($perm);
    $status = $resultado ? '✅ SIM' : '❌ NÃO';
    echo "   podeGerir('{$perm}'): {$status}\n";
}

echo "\n📋 PERMISSÕES ATIVAS (getPermissoesAtivas):\n";
$permissoesAtivas = $funcionario->getPermissoesAtivas();
echo "   Total: " . count($permissoesAtivas) . "\n";
if (count($permissoesAtivas) > 0) {
    echo "   Lista: " . implode(', ', $permissoesAtivas) . "\n";
} else {
    echo "   ⚠️  Nenhuma permissão ativa!\n";
}

echo "\n🔧 TESTE DE VERIFICAÇÃO DETALHADA:\n";
foreach ($permissoes as $perm) {
    $valorRaw = $funcionario->getRawOriginal($perm);
    $valorCast = $funcionario->getAttribute($perm);
    $temPermissao = $funcionario->temPermissao($perm);
    $podeGerir = $user->podeGerir($perm);
    
    echo "\n   {$perm}:\n";
    echo "      Raw: " . var_export($valorRaw, true) . " (" . gettype($valorRaw) . ")\n";
    echo "      Cast: " . var_export($valorCast, true) . " (" . gettype($valorCast) . ")\n";
    echo "      temPermissao(): " . var_export($temPermissao, true) . "\n";
    echo "      podeGerir(): " . var_export($podeGerir, true) . "\n";
    
    // Verificar condições
    $cond1 = ($valorRaw === 1);
    $cond2 = ($valorRaw === '1');
    $cond3 = ($valorRaw === true);
    $cond4 = ($valorCast === true);
    
    echo "      Condições:\n";
    echo "         raw === 1: " . var_export($cond1, true) . "\n";
    echo "         raw === '1': " . var_export($cond2, true) . "\n";
    echo "         raw === true: " . var_export($cond3, true) . "\n";
    echo "         cast === true: " . var_export($cond4, true) . "\n";
}

echo "\n" . str_repeat("=", 60) . "\n";
echo "✅ Teste concluído!\n";


