<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRetail;

class GoogleCloudRetailV2ConversationalSearchResponse extends \Google\Collection
{
  /**
   * Unknown.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * Response generation is being streamed.
   */
  public const STATE_STREAMING = 'STREAMING';
  /**
   * Response generation has succeeded.
   */
  public const STATE_SUCCEEDED = 'SUCCEEDED';
  protected $collection_key = 'userQueryTypes';
  /**
   * Conversation UUID. This field will be stored in client side storage to
   * maintain the conversation session with server and will be used for next
   * search request's ConversationalSearchRequest.conversation_id to restore
   * conversation state in server.
   *
   * @var string
   */
  public $conversationId;
  protected $conversationalFilteringResultType = GoogleCloudRetailV2ConversationalSearchResponseConversationalFilteringResult::class;
  protected $conversationalFilteringResultDataType = '';
  /**
   * The conversational answer-based text response generated by the Server.
   *
   * @var string
   */
  public $conversationalTextResponse;
  protected $followupQuestionType = GoogleCloudRetailV2ConversationalSearchResponseFollowupQuestion::class;
  protected $followupQuestionDataType = '';
  protected $refinedSearchType = GoogleCloudRetailV2ConversationalSearchResponseRefinedSearch::class;
  protected $refinedSearchDataType = 'array';
  /**
   * Output only. The state of the response generation.
   *
   * @var string
   */
  public $state;
  /**
   * The types Retail classifies the search query as. Supported values are: -
   * "ORDER_SUPPORT" - "SIMPLE_PRODUCT_SEARCH" - "INTENT_REFINEMENT" -
   * "PRODUCT_DETAILS" - "PRODUCT_COMPARISON" - "DEALS_AND_COUPONS" -
   * "STORE_RELEVANT" - "BLOCKLISTED" - "BEST_PRODUCT" - "RETAIL_SUPPORT" -
   * "DISABLED"
   *
   * @var string[]
   */
  public $userQueryTypes;

  /**
   * Conversation UUID. This field will be stored in client side storage to
   * maintain the conversation session with server and will be used for next
   * search request's ConversationalSearchRequest.conversation_id to restore
   * conversation state in server.
   *
   * @param string $conversationId
   */
  public function setConversationId($conversationId)
  {
    $this->conversationId = $conversationId;
  }
  /**
   * @return string
   */
  public function getConversationId()
  {
    return $this->conversationId;
  }
  /**
   * This field specifies all related information that is needed on client side
   * for UI rendering of conversational filtering search.
   *
   * @param GoogleCloudRetailV2ConversationalSearchResponseConversationalFilteringResult $conversationalFilteringResult
   */
  public function setConversationalFilteringResult(GoogleCloudRetailV2ConversationalSearchResponseConversationalFilteringResult $conversationalFilteringResult)
  {
    $this->conversationalFilteringResult = $conversationalFilteringResult;
  }
  /**
   * @return GoogleCloudRetailV2ConversationalSearchResponseConversationalFilteringResult
   */
  public function getConversationalFilteringResult()
  {
    return $this->conversationalFilteringResult;
  }
  /**
   * The conversational answer-based text response generated by the Server.
   *
   * @param string $conversationalTextResponse
   */
  public function setConversationalTextResponse($conversationalTextResponse)
  {
    $this->conversationalTextResponse = $conversationalTextResponse;
  }
  /**
   * @return string
   */
  public function getConversationalTextResponse()
  {
    return $this->conversationalTextResponse;
  }
  /**
   * The conversational followup question generated for Intent refinement.
   *
   * @param GoogleCloudRetailV2ConversationalSearchResponseFollowupQuestion $followupQuestion
   */
  public function setFollowupQuestion(GoogleCloudRetailV2ConversationalSearchResponseFollowupQuestion $followupQuestion)
  {
    $this->followupQuestion = $followupQuestion;
  }
  /**
   * @return GoogleCloudRetailV2ConversationalSearchResponseFollowupQuestion
   */
  public function getFollowupQuestion()
  {
    return $this->followupQuestion;
  }
  /**
   * The proposed refined search queries. They can be used to fetch the relevant
   * search results. When using CONVERSATIONAL_FILTER_ONLY mode, the
   * refined_query from search response will be populated here.
   *
   * @param GoogleCloudRetailV2ConversationalSearchResponseRefinedSearch[] $refinedSearch
   */
  public function setRefinedSearch($refinedSearch)
  {
    $this->refinedSearch = $refinedSearch;
  }
  /**
   * @return GoogleCloudRetailV2ConversationalSearchResponseRefinedSearch[]
   */
  public function getRefinedSearch()
  {
    return $this->refinedSearch;
  }
  /**
   * Output only. The state of the response generation.
   *
   * Accepted values: STATE_UNSPECIFIED, STREAMING, SUCCEEDED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * The types Retail classifies the search query as. Supported values are: -
   * "ORDER_SUPPORT" - "SIMPLE_PRODUCT_SEARCH" - "INTENT_REFINEMENT" -
   * "PRODUCT_DETAILS" - "PRODUCT_COMPARISON" - "DEALS_AND_COUPONS" -
   * "STORE_RELEVANT" - "BLOCKLISTED" - "BEST_PRODUCT" - "RETAIL_SUPPORT" -
   * "DISABLED"
   *
   * @param string[] $userQueryTypes
   */
  public function setUserQueryTypes($userQueryTypes)
  {
    $this->userQueryTypes = $userQueryTypes;
  }
  /**
   * @return string[]
   */
  public function getUserQueryTypes()
  {
    return $this->userQueryTypes;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRetailV2ConversationalSearchResponse::class, 'Google_Service_CloudRetail_GoogleCloudRetailV2ConversationalSearchResponse');
