<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowCxV3ToolUse extends \Google\Model
{
  /**
   * Optional. Name of the action to be called during the tool use.
   *
   * @var string
   */
  public $action;
  /**
   * Output only. The display name of the tool.
   *
   * @var string
   */
  public $displayName;
  /**
   * Optional. A list of input parameters for the action.
   *
   * @var array[]
   */
  public $inputActionParameters;
  /**
   * Optional. A list of output parameters generated by the action.
   *
   * @var array[]
   */
  public $outputActionParameters;
  /**
   * Required. The tool that should be used. Format:
   * `projects//locations//agents//tools/`.
   *
   * @var string
   */
  public $tool;

  /**
   * Optional. Name of the action to be called during the tool use.
   *
   * @param string $action
   */
  public function setAction($action)
  {
    $this->action = $action;
  }
  /**
   * @return string
   */
  public function getAction()
  {
    return $this->action;
  }
  /**
   * Output only. The display name of the tool.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Optional. A list of input parameters for the action.
   *
   * @param array[] $inputActionParameters
   */
  public function setInputActionParameters($inputActionParameters)
  {
    $this->inputActionParameters = $inputActionParameters;
  }
  /**
   * @return array[]
   */
  public function getInputActionParameters()
  {
    return $this->inputActionParameters;
  }
  /**
   * Optional. A list of output parameters generated by the action.
   *
   * @param array[] $outputActionParameters
   */
  public function setOutputActionParameters($outputActionParameters)
  {
    $this->outputActionParameters = $outputActionParameters;
  }
  /**
   * @return array[]
   */
  public function getOutputActionParameters()
  {
    return $this->outputActionParameters;
  }
  /**
   * Required. The tool that should be used. Format:
   * `projects//locations//agents//tools/`.
   *
   * @param string $tool
   */
  public function setTool($tool)
  {
    $this->tool = $tool;
  }
  /**
   * @return string
   */
  public function getTool()
  {
    return $this->tool;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowCxV3ToolUse::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowCxV3ToolUse');
