<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\OnDemandScanning;

class NonCompliantFile extends \Google\Model
{
  /**
   * Command to display the non-compliant files.
   *
   * @var string
   */
  public $displayCommand;
  /**
   * Empty if `display_command` is set.
   *
   * @var string
   */
  public $path;
  /**
   * Explains why a file is non compliant for a CIS check.
   *
   * @var string
   */
  public $reason;

  /**
   * Command to display the non-compliant files.
   *
   * @param string $displayCommand
   */
  public function setDisplayCommand($displayCommand)
  {
    $this->displayCommand = $displayCommand;
  }
  /**
   * @return string
   */
  public function getDisplayCommand()
  {
    return $this->displayCommand;
  }
  /**
   * Empty if `display_command` is set.
   *
   * @param string $path
   */
  public function setPath($path)
  {
    $this->path = $path;
  }
  /**
   * @return string
   */
  public function getPath()
  {
    return $this->path;
  }
  /**
   * Explains why a file is non compliant for a CIS check.
   *
   * @param string $reason
   */
  public function setReason($reason)
  {
    $this->reason = $reason;
  }
  /**
   * @return string
   */
  public function getReason()
  {
    return $this->reason;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NonCompliantFile::class, 'Google_Service_OnDemandScanning_NonCompliantFile');
